
Ext.define('Academia.view.organization.managementaccounting.ManagementAccountingGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.managementGrid',
	title : getCommonTranslation('MGMTACCGRIDTITLE'),
	store:'organization.ManagementAccountingGridStore', 
//	    autoScroll: true,
	    border: true,
	    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	    },
	    
	columns:[{
		header: getCommonTranslation('SHORTCODE'),
		dataIndex:'shortCode',
		sortable : true,
		flex: 0.5
	},{
		header: getCommonTranslation('GROUP_NAME'),
		dataIndex:'unitName',
		sortable : true,
		flex: 1
	},{
		header: getCommonTranslation('GROUP_TYPE'),
		dataIndex:'organizationUnitType',
		flex: 0.5,
		renderer:function(value){	
			return value.value;
		}
	},{
		header:getCommonTranslation('STATUS'),
		dataIndex:'status',
		flex: 0.2,
		renderer:function(value){
			return statusRender(value);
		}
	}],
	
	 tbar: [{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip : getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip : getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip : getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'	
	    },{
	        xtype: 'button',
	        itemId: 'btnDelete',
	        tooltip : getCommonTranslation('DELETE'),
	        cls: 'CustomToolbarBtnReject',
	        glyph: ICONGLYPH.DELETEGLYPH
	    }],
	    
	    dockedItems : [ {
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    		xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	    		store:'organization.ManagementAccountingGridStore', 
	    	    emptyMsg :'<span id="manageAccountingGridId" style="margin-top: 60px !important">'+ getCommonTranslation('NO_UNIT_TO_DISPLAY')+'</span>',
	    	    displayInfo : true
	    	} ]
	        }
	        ]
});