Ext.define('Academia.view.organization.sasaumaumapping.AllocatedALPGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.allocatedalpgrid',
    flex: 1,
    hidden: true,
    title: getCommonTranslation('ALLOCATED_ALP_GRID_TITLE'),
    store: 'organization.susaumapping.AllocatedALPStore',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [/*{
        dataIndex: 'id',
        hidden: true
    }, {
        dataIndex: 'organizationSupervisoryUnitId',
        hidden: true
    },*/ {
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academy.academyName',
        flex: 0.2
    }, {
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'location.name',
        flex: 0.2
    }, {
        header: getCommonTranslation('PURPOSE'),
        dataIndex: 'purpose',
        flex: 0.2
    }, {
        header: getCommonTranslation('START_DATE'),
        dataIndex: 'startDate',
        xtype: 'datecolumn',
        dateFormat: 'd-m-Y',
        flex: 0.1,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCommonTranslation('END_DATE'),
        dataIndex: 'tillDate',
        xtype: 'datecolumn',
        dateFormat: 'd-m-Y',
        flex: 0.1,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        xtype: 'actioncolumn',
        header: getCommonTranslation('UNLINK'),
        icon: 'resources/images/unlink2.png',
        tooltip: getCommonTranslation('UNLINK'),
        itemId: 'allocatedGridActionColumnId',
        flex: 0.2
    }],
    dockedItems : [ {
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
	        displayInfo: true,
	        store: 'organization.susaumapping.AllocatedALPStore'
    	 }]
    }]

});