/**
 * This form is used for faculty Assessment Scheme
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.course.FacultyEvaluationQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultyevaluationquicksearchform',
    //frame : true,
    title: getCompletionModuleTranslation('QUICK_SEARCH'),
    items: [{
        xtype: 'form',
        itemId: 'evaluationQuickSearch',
        defaults: {
            labelAlign: 'top'
        },
        standardSubmit: false,
        items: [{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: 226
                },
                items: [{
                    xtype: 'customcombobox',
                    name: 'evaluationProgram',
                    itemId: 'evaluationProgramId',
                    store: 'common.ProgramByAcAndLoIdStore',
                    fieldLabel: getPersonModuleTranslation('PROGRAM'),
                    
                    editable: false,
                    valueField: 'id',
                    displayField: 'value'
                },{
                	 xtype: 'customcombobox',
                     name: 'evaluationBatch',
                     itemId : 'evaluationBatchId',
                     fieldLabel: getCompletionModuleTranslation('BATCH'),
                     
                     store: 'common.BatchesByProgramId',
                     displayField: 'value',
                     valueField: 'id'
                },{
                    xtype: 'customcombobox',
                    name: 'evaluationSection',
                    itemId :'evaluationSectionId',
                    store: 'coursetransaction.sectionmanagement.SectionMultiSelect',
                    fieldLabel: getCompletionModuleTranslation('SECTION'),
                    editable: false,
                    
                    valueField: 'id',
                    displayField: 'value'
                }]
            }, {
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: 226
                },
                items: [{
                    xtype: 'customcombobox',
                    name: 'evaluationPeriod',
                    itemId: 'period',
                    store:'admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
                    fieldLabel: getPersonModuleTranslation('ATTENDANCE_PERIOD'),
                    
                    editable: false,
                    valueField: 'id',
                    displayField: 'value'
                },{
                    xtype: 'customcombobox',
                    name: 'evaluationYear',
                    store: 'scholarships.AcademyYears',
                    fieldLabel: getPersonModuleTranslation('ATTENDANCE_ACADEMIC_YEAR'),
                    
                    editable: false,
                    valueField: 'id',
                    displayField: 'value'
                }]
            },
            {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'attendanceSearchButtonId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                text: getCompletionModuleTranslation('CLEAR_SEARCH'),
                itemId: 'clearSearch',
                buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});