/**
 * @sachin.Bangar
 * This is used for faculty performance grid
 */

Ext.define('Academia.view.personinfo.common.course.FacultyPerformanceGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.facultyperformancegrid',
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   
    columns: [{
        header: getPersonModuleTranslation('SR_NO'),
        dataIndex: 'sr_no',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('PARAMETERS'),
        dataIndex: 'parameters',
        sortable: true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('RATING'),
        dataIndex: 'rating',
        sortable:true,
        flex: .1
    }],
    
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.FacultyPerformanceGridStore');
    }
});