/**
 *   @author bhanu ps
      //V2D-306946
 */
Ext.define('Academia.view.personinfo.common.course.StudentCourseReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentcoursereportgrid',
	//store: 'program.programDetails.programBatches.courseParameter.StudentCourseReportStore',
	title: getExaminationTranslation('STUDENT_COURSE_REPORT'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'mycoursedetails': 3
		}
	},
	//cls: 'studentCourseReportGridCls',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},

	selType:'checkboxmodel',
	selModel: {
		mode:'SINGLE',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	//V2D-291664,need to comment feature for:-V2D-328647,V2D-328582
	features: [/*{
	        id: 'group',
	        ftype: 'groupingsummary',
	        groupHeaderTpl: '{name}',
	        hideGroupedHeader: false,
	        enableGroupingMenu: true
	    },*/{ 
	    	ftype: 'summary', 
	    	dock: 'bottom'
	    }], 

	    dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    		xtype : 'custompagingtoolbar',
	    		plugins:['pagesize'],
	    		store : 'program.programDetails.programBatches.courseParameter.StudentCourseReportStore',
	    		emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    		displayInfo : true
	    	} ]
	    }],
	    initComponent: function() {

	    	var grid=this;                   
	    	grid.addExportToolBarItems(grid);
	    	this.callParent(arguments);     
	    },
	    tbar: [{
	    	xtype: 'button',
	    	text: getCommonTranslation('SAVE'),
	    	itemId: 'btnSaveItemId',
	    	ui: 'CustomBtnSubmit',
	    	formBind:true,
	    	cls: 'x-btn x-unselectable x-btn-CustomBtnSubmit-small x-noicon x-btn-noicon x-btn-CustomBtnSubmit-small-noicon',
	    	scale: CONSTANTS.BUTTONSIZE
	    },{
	    	xtype: 'button',
	    	itemId: 'requestExamCancellationButtonId',
	    	text: getCommonTranslation('REQUEST_EXAM_CANCELLATION'),
	    	disabled : false
	    },{
	    	xtype:'displayfield',
	    	name : 'showExamCancellationMessage',
	    	itemId : 'showExamCancellationMessageId',
	    	hidden:true
	    }],
	    columns: [{
	    	header: getExaminationTranslation('PERIOD'),
	    	dataIndex: 'programPeriodName',
	    	flex:.1,
	    	sortable:true,

	    },{
	    	header:getCommonTranslation("COURSE_CODE"),
	    	dataIndex: 'courseCode',
	    	flex:.1,
	    	sortable:true,
	    },{
	    	header:getCommonTranslation("COURSE_NAME"),
	    	dataIndex: 'courseName',
	    	flex:.1,
	    	sortable:true,
	    },{
	    	header:getCommonTranslation('COURSE_VARIANT'),
	    	dataIndex: 'courseVariantCode',
	    	flex:.1,
	    	sortable:true,
	    	field: {
	    		xtype: 'textfield'
	    	},
	    	summaryRenderer: function(value, summaryData, data) {
	    		var text = "Total";
	    		if(data.internalId.indexOf('summary') > 0){
	    			text = "Total Credits:";
	    		}
	    		return text;
	    	}
	    },{
	    	header:getCommonTranslation('CREDITS'),
	    	dataIndex: 'credits',
	    	flex:.05,
	    	sortable:true,
	    	summaryType: 'sum'
	    },  {
	    	header:getCommonTranslation('CREDIT_OBTAINED'),
	    	dataIndex: 'obtainedCourseCredit',
	    	flex:.1,
	    	sortable:true,
	    },
	    {
	    	header:getCommonTranslation('COURSE_ID'),
	    	dataIndex: 'courseId',
	    	flex:.1,
	    	sortable:true,
	    	hidden:true
	    },{
	    	header :getCommonTranslation('FACULTY') ,
	    	dataIndex : 'faculty',
	    	flex:.1,
	    	sortable : true,
	    	renderer:function(value,meta,record){
	    		if(record.data.faculty==null){
	    			return "-";
	    		} else {
	    			return value;
	    		}
	    	}
	    },{
	    	header: getCommonTranslation('MIDTERM_GRADE_MARKS'),
	    	dataIndex: 'midtermGradeMarks',
	    	flex:.1,
	    	sortable:true,
	    	editor : {
	    		xtype: 'textfield',
	    		name: 'midtermGradeMarks',
	    		maxLength:10
	    	},
	    	renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	    		if(isNullOrEmpty(val)){
	    			rec.tdCls = 'gridInputCustomStyle'; 
	    			return getExaminationTranslation('CLICK_TO_ENTER');
	    		}else{
	    			return val;
	    		}
	    	}
	    },{
	    	header:getCommonTranslation('WHETHER_OPTIONAL'),
	    	dataIndex: 'whetherOptional',
	    	flex:.05,
	    	sortable:true,
	    	hidden:true,
	    	renderer:function(value,meta,record){
	    		if(record.data.whetherOptional){
	    			return "<span style=\'color:green\'>Yes</span>";
	    		} else {
	    			return "<span style=\'color:red\'>No</span>";
	    		}
	    	}
	    },{
	    	header:getCommonTranslation('WHETHER_ADDITIONAL'),
	    	dataIndex: 'whetherAdditional',
	    	flex:.05,
	    	sortable:true,
	    	hidden:true,
	    	renderer:function(value,meta,record){
	    		if(record.data.whetherAdditional){
	    			return "<span style=\'color:green\'>Yes</span>";
	    		} else {
	    			return "<span style=\'color:red\'>No</span>";
	    		}
	    	}
	    },{
	    	header:getCommonTranslation('WITHDRAWL'),
	    	dataIndex: 'withDrawl',
	    	flex:.05,
	    	sortable:true,
	    	hidden:true,
	    	renderer:function(value,meta,record){
	    		if(!isNullOrEmpty(record.data.withDrawl) && record.data.withDrawl){
	    			return "<span style=\'color:green\'>Yes</span>";
	    		} else if(isNullOrEmpty(record.data.withDrawl)){
	    			return "-";
	    		} else {
	    			return "<span style=\'color:red\'>No</span>";
	    		}
	    	}
	    },{
	    	header:getCommonTranslation('MARKS_OR_GRADE_Obtained'),
	    	dataIndex: 'marksObtained',
	    	flex:.05,
	    	sortable:true,
	    	hidden:true
	    },{
	    	header:getCommonTranslation('WHETHER_PASSED'),
	    	dataIndex: 'whetherPassed',
	    	flex:.05,
	    	sortable:true,
	    	hidden:true,
	    	renderer:function(value,meta,record){
	    		if(!isNullOrEmpty(record.data.whetherPassed) && record.data.whetherPassed){
	    			return "<span style=\'color:green\'>Yes</span>";
	    		} else if(isNullOrEmpty(record.data.whetherPassed)){
	    			return "-";
	    		} else {
	    			return "<span style=\'color:red\'>No</span>";
	    		}
	    	}
	    },{
	    	header:getCommonTranslation('STUDENT_COURSE_ENROLLMENT_ID'),
	    	dataIndex: 'studentCourseEnrollmentId',
	    	flex:.1,
	    	sortable:true,
	    	hidden:true
	    },{
	    	header :getCommonTranslation('TEACHER_EMAIL') ,
	    	dataIndex : 'facultyMail',
	    	flex:.1,
	    	sortable : true,
	    	renderer:function(value,meta,record){
	    		if(isNullOrEmpty(record.data.facultyMail)){
	    			return "-";
	    		} else {
	    			return Ext.String.format('<a href="mailto:{0}">{1}</a>', value, value);
	    			//return value;
	    		}
	    	}
	    },{
	    	header:getProgramandcourseTranslation('COMMENT_REASON'),
	    	dataIndex: 'reason',
	    	flex:.1,
	    	sortable:true,
	    	hidden:true,
	    	renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	    		if(!isNullOrEmpty(val)){
	    			rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    			rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 4;-webkit-box-orient: vertical;line-height: 15px;max-height: 73px;min-width: 16ch;max-width: 17ch;';
	    		}
	    		return val;
	    	}
	    },{
	    	header:getProgramandcourseTranslation('LESSON_PLAN'),
	    	dataIndex: 'lessonPlanmodel',
	    	flex:.1,
	    	hidden:true,
	    	renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	    		if(!isNullOrEmpty(record.data.lessonPlanmodel) && record.data.lessonPlanmodel.length){
	    			if(record.data.lessonPlanmodel.length > 1){
	    				return '<a  href="#">'+record.data.lessonPlanmodel.length+'</a>';
	    			}
	    			return '<a  href="#">'+record.data.lessonPlanmodel[0].code+'</a>';
	    		}
	    		return '';
	    	}
	    },{
	    	header:getProgramandcourseTranslation('COURSE_ENROLLMENT_STATUS'),
	    	dataIndex: 'enrollCourseStatus',
	    	flex:.1,
	    	sortable:true,
	    	hidden:false,
			editor: {
				xtype: 'customcombobox',
				itemId: 'enrollCourseStatusId',
				name: 'enrollCourseStatus',
				store: Ext.create('Academia.store.common.ChangeEnrollmentMasterCourseStatusStore'),					
				valueField: 'value',
				displayField: 'value',
				forceSelection: true,
				editable: false,
				typeAhead: false,
			}, renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				var courseStatus = record.data.enrollCourseStatus;
				if (courseStatus != '' && courseStatus != null) {
					return courseStatus;
				} else {
					rec.tdCls = 'gridInputCustomStyle';
					return getCommonTranslation('SELECT_COURSE_ENROLLMENT_STATUS');
				}
			}
	    }],
		plugins: [{
		        ptype: 'cellediting',
		        clicksToEdit: 1,
		        listeners: {
		            beforeedit: function(editor, context) {
		            	 if(editor.context.field=='enrollCourseStatus'){
							var combo = context.column.getEditor(); // Access the editor's field (the combo box)
					        var store = combo.getStore(); // Get the store of the combo box
					
					        if (store) {
					            var enrollCourseStatus = context.record.get('enrollCourseStatus');
								if(isNullOrEmpty(enrollCourseStatus))
								enrollCourseStatus=context.record.get('enrolledCourseStatus');
					            var isCurrentAcademicTerm = context.record.get('isCurrentAcademicTerm');
					
					            // Set extra parameters on the store's proxy
					            store.getProxy().extraParams = {
					                fromStatus: enrollCourseStatus,
					                isCurrentAcademicTerm: isCurrentAcademicTerm
					            };
					        }
			               
			                    store.load();
				         		}
				        	},canceledit: function(editor, context) {
					           var enrollCourseStatus = context.record.get('enrollCourseStatus');
					            var enrolledCourseStatus = context.record.get('enrolledCourseStatus');
					
					            if (isNullOrEmpty(enrollCourseStatus) && !isNullOrEmpty(enrolledCourseStatus)) {
					                context.record.set('enrollCourseStatus', enrolledCourseStatus);
					            }
					        },edit: function(editor, context) {
					           var enrollCourseStatus = context.record.get('enrollCourseStatus');
					            var enrolledCourseStatus = context.record.get('enrolledCourseStatus');
					
					            if (isNullOrEmpty(enrollCourseStatus) && !isNullOrEmpty(enrolledCourseStatus)) {
					                context.record.set('enrollCourseStatus', enrolledCourseStatus);
					            }
					        }
				        }
		    }],
	    initComponent: function() {
	    	var this$ = this;
	    	var store = this$.buildStore();
	    	Ext.apply(this$, {
	    		store: store,
	    		dockedItems: [{
	    			xtype: 'toolbar',
	    			dock: 'bottom',
	    			items: [{
	    				xtype: 'custompagingtoolbar',
	    				plugins: ['pagesize'],
	    				store: store,
	    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	    				displayInfo: true
	    			}]
	    		}]
	    	});
	    	this$.addExportToolBarItems(this$);
	    	this$.callParent(arguments);
	    },
	    buildStore: function() {
	    	return Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.StudentCourseReportStore');
	    }
});
