/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.personinfo.common.course.StudentTimeTableSearchFilter', {
	extend : 'Ext.form.FormPanel',
    alias: 'widget.studenttimetablesearchfilter',
    plugins : "formlabelrequired",
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel',
	items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype : 'customcombobox',
			name : 'studentAcademyLocation',
			itemId:'studentAcademyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
            //allowBlank: false,
            editable: false,
            width: 460,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
			name : 'programId',
			itemId : 'programBatch_programId',
			store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
			displayField:'valueCode',
			valueField:'id',
			typeAhead:true,
			allowBlank:false,
			forceSelection:true
		}, {
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'programBatch_batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			allowBlank:true,
			forceSelection:true,
			editable:false
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdItemId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank:true,
			typeAhead:true,
			disabled:true,
			editable:false
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}]
});