Ext.define('Academia.view.personinfo.common.disciplinaryactivity.DisciplinaryActionFormSU', {
	extend: 'Ext.form.Panel',
	//extend:'Academia.view.common.CustomFieldForm',
	customFieldEntity:CONSTANTS.DISCIPLINARY_ACTION_CF_DATA,
	alias: 'widget.disciplinaryactionformsu',
	border : false,
	frame : false,
	width:'100%',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'disciplinaryactionformsu',
		plugins: "formlabelrequired",
		items: [{
			xtype: 'hidden',
			itemId: 'hiddenField',
			name: 'hiddenField'
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype:'fieldset',
				width: '100%',
				collapsible:true,
				//collapsed: true,
				title:getPersonModuleTranslation('MISCONDUCT_DETAILS'),
				style:{marginLeft:'0px',marginRight:'0px',marginTop:'0px'}, 
				items:[{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 250,
						labelAlign:'top'
					},
					items: [{
						xtype:'nestedJsonCombo',
						fieldLabel:getPersonModuleTranslation('TYPE_OF_MISCONDUCT'),
						name:'typeOfMisconduct',
						itemId : 'typeOfMisconduct',
						store:'personinfo.common.disciplinaryactivity.DisciplinarySUTypeOfMisconductSearchCombo',
						allowBlank: false,
						forceSelection: true,
						valueField: 'id',
						displayField: 'value',
						//editable: false,
					},{
						xtype: 'datefield',
						fieldLabel: getPersonModuleTranslation('DATE_OF_MISCONDUCT'),
						name: 'dateOfMisconduct',
						itemId : 'dateOfMisconduct',
						allowBlank: false,
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
					},
					{
						xtype:'nestedJsonCombo',
						//overrideSetValue:false,
						fieldLabel:getPersonModuleTranslation('DISCIPLINARY_COMMITTEE'),
						name:'disciplinaryCommittee',
						itemId : 'disciplinaryCommittee',
						store:'personinfo.common.disciplinaryactivity.DisciplinaryCommitteeSU',
						valueField: 'id',
						displayField: 'value',
						editable: false,
					}]
				},{


					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 250
					},
					items: [{xtype: 'radiogroup',
						fieldLabel: getPersonModuleTranslation('TEMPORARY_SUSPENSION'), 
						itemId: 'temporarysSuspension',
						name:'temporarysSuspension',
						labelAlign:'top',
						vertical: false,
						layout: {
							type: 'hbox'
						},
						items: [{
							boxLabel: getMessagingModuleTranslation('YES'),
							itemId: 'yes',
							name: 'temporarysSuspension',
							inputValue: true,
						}, {
							boxLabel: getMessagingModuleTranslation('NO'),
							itemId: 'no',
							name: 'temporarysSuspension',
							inputValue: false,
							checked: true
						}]
						},
						  {
							xtype: 'datefield',
							fieldLabel: getPersonModuleTranslation('TEMPORARY_SUSPENSION_DATE'),
							name: 'temporarySuspensionDate',
							itemId : 'temporarySuspensionDate',
							allowBlank: false,
							disabled:true,
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							}},{
								xtype:'nestedJsonCombo',
								fieldLabel:getPersonModuleTranslation('TEMPORARY_SUSPENSION_ACCESS_RESTRICTION'),
								name:'temporarySuspensionAccessRestriction',
								itemId : 'temporarySuspensionAccessRestriction',
								store:'personinfo.common.disciplinaryactivity.DisciplinarySUAccessTemporaryRestriction',
								valueField: 'id',
								displayField: 'value',
								forceSelection: true,
								disabled:true
							}]

				},{

					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 250
					},
					items: [{
						xtype: 'radiogroup',
						fieldLabel: getPersonModuleTranslation('TEMPORARY_SUSPENSION_LAPSE'), 
						itemId: 'temporarysSuspensionLapse',
						name:'temporarysSuspensionLapse',
						labelAlign:'top',
						vertical: false,
						disabled:true,
						layout: {
							type: 'hbox'
						},
						items: [{
							boxLabel: getMessagingModuleTranslation('YES'),
							itemId: 'yes',
							name: 'temporarysSuspensionLapse',
							inputValue: true
						}, {
							boxLabel: getMessagingModuleTranslation('NO'),
							itemId: 'no',
							name: 'temporarysSuspensionLapse',
							inputValue: false,
							checked: true
						}]
					},{

						xtype: 'datefield',
						fieldLabel: getPersonModuleTranslation('TEMPORARY_SUSPENSION_LAPSE_DATE'),
						name: 'temporarySuspensionLapseDate',
						itemId : 'temporarySuspensionLapseDate',
						allowBlank: false,
						disabled:true,
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
					}]

				}]
			}]

		},{

			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype:'fieldset',
				width: '100%',
				collapsible:true,
				//collapsed: true,
				title:getPersonModuleTranslation('DISCIPLINARY_COMMITTEE_DETAIL'),
				//style:{marginLeft:'0px',marginRight:'0px',marginTop:'0px'}, 
				items:[{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 250,
						labelAlign:'top'
					},
					items: [{
						xtype:'nestedJsonCombo',
						//overrideSetValue:false,
						fieldLabel:getPersonModuleTranslation('DISCIPLINARY_DETERMINATION'),
						name:'disciplinaryDetermination',
						itemId : 'disciplinaryDetermination',
						store:'personinfo.common.disciplinaryactivity.SUDisciplinaryDeterminationComboStore',
						displayField: 'value',
						valueField: 'id',
						
					},{
						xtype: 'datefield',
						fieldLabel: getPersonModuleTranslation('DISCIPLINARY_DETERMINATION_DATE'),
						name: 'disciplinaryDeterminationDate',
						itemId : 'disciplinaryDeterminationDate',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
					},
					{
						xtype: 'datefield',
						fieldLabel: getPersonModuleTranslation('DISCIPLINARY_COMMITTEE_HEARING_DATE'),
						name: 'disciplinaryCommitteeHearingDate',
						itemId : 'disciplinaryCommitteeHearingDate',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}

					}]
				},{

					xtype: 'fieldcontainer',
					width:'100%',
					defaults :{
						width: 250,
						labelAlign:'top'
					},
					items: [{
						xtype: 'radiogroup',
						fieldLabel: getPersonModuleTranslation('IS_GUILTY'), 
						itemId: 'isGuilty',
						name:'isGuilty',
						labelAlign:'top',
						vertical: false,
						allowBlank: false,
						layout: {
							type: 'hbox'
						},
						items: [{
							boxLabel: getMessagingModuleTranslation('YES'),
							itemId: 'isGuiltyyes',
							name: 'isGuilty',
							inputValue: true

						}, {
							boxLabel: getMessagingModuleTranslation('NO'),
							itemId: 'isGuiltyno',
							name: 'isGuilty',
							inputValue: false,
							checked: true
						}]
					}]

				}]
			}]


		},{


			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype:'fieldset',
				width: '100%',
				collapsible:true,
				//collapsed: true,
				title:getPersonModuleTranslation('APPEAL_DETAILS'),
				//style:{marginLeft:'0px',marginRight:'0px',marginTop:'0px'}, 
				items:[{
					xtype: 'fieldcontainer',
					width:'100%',
					/*layout: {
					type: 'hbox'
				},*/
					defaults :{
						width: 220,
						labelAlign:'top'
					},
					items: [{

						xtype: 'fieldcontainer',
						width:'100%',
						defaults :{
							width: 250,
							labelAlign:'top'
						},
						layout: {
							type: 'hbox'
						},
						items: [{
							xtype: 'radiogroup',
							fieldLabel: getPersonModuleTranslation('APPEAL'), 
							itemId: 'appeal',
							name:'appeal',
							labelAlign:'top',
							vertical: false,
							layout: {
								type: 'hbox'
							},
							items: [{
								boxLabel: getPersonModuleTranslation('YES'),
								itemId: 'appealYes',
								name: 'appeal',
								inputValue: true
							}, {
								boxLabel: getPersonModuleTranslation('NO'),
								itemId: 'appealNo',
								name: 'appeal',
								inputValue: false,
								checked: true
							}]
						},{

							xtype: 'datefield',
							fieldLabel: getPersonModuleTranslation('APPEAL_DATE'),
							name: 'appealDate',
							itemId : 'appealDate',
							disabled:true,
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							}

						},{
							xtype:'nestedJsonCombo',
							fieldLabel:getPersonModuleTranslation('APPEAL_OUTCOME'),
							name:'appealOutcome',
							itemId : 'appealOutcome',
							store:'personinfo.common.disciplinaryactivity.DisciplinarySUAppealOutcome',
							valueField: 'id',
							displayField: 'value',
							allowBlank: false,
							forceSelection: true,
							disabled:true
						}]


					}]
				},{

					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 250,
						labelAlign:'top'
					},
					items: [{
						xtype: 'textareafield',
						fieldLabel: getPersonModuleTranslation('MISCONDUCT_DETAILS'),
						name: 'misconductDetail',
						itemId : 'misconductDetail',
						maxLength:1000,
						width:380
					},{
						xtype: 'textareafield',
						fieldLabel: getPersonModuleTranslation('NOTES_REMARKS'),
						name: 'notesRemarks',
						itemId : 'notesRemarks',
						maxLength:1000,
						width:380

					}]

				}]
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype:'fieldset',
				width: '100%',
				collapsible:true,
				//collapsed: true,
				title:getPersonModuleTranslation('SANCTION_DETAILS'),
				//style:{marginLeft:'0px',marginRight:'0px',marginTop:'0px'}, 
				items:[{
					xtype: 'fieldcontainer',
					width:'100%',
					defaults :{
						width:250
					},
					items : [{
						xtype:'sanctiondetailsgrid',
						itemId:'sanctiondetailsgrid',
						style:{
							marginLeft:'0px',
						},
						flex:.1,
						width:775
					}]


				}]
			}]
		},{

			xtype: 'fieldcontainer',    
			layout : {
				type : 'vbox'
			},
			cls:'horizontal-scrolling-fix',
			defaults : {
				width : 460,
				labelAlign : 'top'
			},
			items : [{
				xtype:'disciplinaryactiondocumentgrid',
				itemId:'disciplinaryactiondocumentgrid',
				hidden:true,
				style:{
					marginLeft:'0px',
				},
				flex:.1
			}]


			}, {
				xtype: 'fieldcontainer',
				layout: 'vbox',
				defaults: {
					labelAlign: 'top',
					width: 460
				},
				items: [{
					xtype: 'checkboxfield',
					itemId: 'notifyStudent',
					labelAlign: 'right',
					region: 'south',
					boxLabel: getPersonModuleTranslation('NOTIFY_STUDENT'),
					name: 'notifyStudent',
					checked: false,
					inputValue: true,
					uncheckedValue: false,
					hidden: true,
					style: {
						marginTop: '10px'
					}
				}]
			}, { 
			xtype:'fieldcontainer',
			width:'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'submitButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonSUId',
				scale: CONSTANTS.BUTTONSIZE

			},
			{
				xtype: 'button',
				name: 'courseSyllabus',
				text:getCommonTranslation('UPLOAD_DOC'),
				itemId: 'uploadDisciplinarySUItemId',
				ui: 'CustomBtnThird',
				scale : CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
