/**
 * This form is used for the student & faculty feedback given form.
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.feedback.FeedbackGivenForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.feedbackgivenform',
    border: false,
    frame: false,
    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top',
        width: 226
    },
    items: [{
        xtype: 'hidden',
        itemId: 'feedback_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'textfield',
        fieldLabel: getPersonModuleTranslation('QUESTIONNAIRE_NUMBER'),
        
        name: 'questionnaireNumber'
    }, {
        xtype: 'textfield',
        fieldLabel: getPersonModuleTranslation('FEEDBACK_GIVEN_TO'),
        
        name: 'feedbackGivenTo'
    },{
        xtype: 'datefield',
        fieldLabel: getPersonModuleTranslation('SUBMITTED_DATE'),
        name: 'submittedDate',
		listeners: {
			render: function(field) {
				return dateFormatRender(field);
			}
		}
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
