/**
 * @author <a href="sooraj.prasad@serosoft.in">Sooraj Prasad</a>
 *
 */
Ext.define('Academia.view.personinfo.common.pasthistory.LearningAllowanceGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.learningallowancegrid',
	title: getPersonModuleTranslation('LEARNING_ALLOWANCE'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
	autoScroll: false,
	/*defaults:{
        width:'100%'
    },
    layout:'vbox',*/
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],

	columns: [ {
		header: getPersonModuleTranslation('LEARNING_ALLOWANCE'), 
		dataIndex: 'learningAllowanceCSMMapping',
		sortable: true,
		flex: .2,
	    renderer:function(record){
    	var result='';
    	for(var i in record){
    		result=result.concat(record[i].learningAllowancesCSM.value);
    		result=result.concat(",");
    	}
    	return result.substring(0,result.length-1);
    }
	}, {
		header: getCommonTranslation('DESCRIPTION'), 
		dataIndex: 'description',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('VALID_FROM'), 
		dataIndex: 'validForm',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('ACCOUNT_TYPE'), 
		dataIndex: 'accountType',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.accountType.value;
			}                        
		}

	}, {
		header: getCommonTranslation('APPLIES_TO'), 
		dataIndex: 'appliesTo',
		sortable:true,
		flex: .2,
		 renderer:function(record){
		    	var result='';
		    	for(var i in record){
		    		result=result.concat(record[i].lAAcademyLocation.value);
		    		result=result.concat(",");
		    	}
		    	return result.substring(0,result.length-1);
		    }
	},{
		header: getCommonTranslation('GRANTED_BY'), 
		dataIndex: 'grantedby',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.grantedby.value;
			}                        
		}
	},{
		header: getCommonTranslation('DATE_MODIFIED'), 
		dataIndex: 'dateModified',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.pasthistory.LearningAllowanceStore');
    }
});