/**
 * @author swapnil.patil
 * Physical Characteristics Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.PhysicalCharacteristicsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.physicalcharacteristicsform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'phyChar_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, 
	{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
    		xtype: 'numberfield',
    		fieldLabel: getPersonModuleTranslation('HEIGHT'),
    		name: 'height',
    		maxLength: 5,
    		minLength: 2,
    		minValue: 0,
    		enforceMaxLength: true,
    		allowBlank: false
    	},
    	{
    		xtype: 'numberfield',
    		fieldLabel: getPersonModuleTranslation('WEIGHT'),
    		name: 'weight',
    		maxLength: 5,
    		minLength: 2,
    		minValue: 0,
    		enforceMaxLength: true,
    		allowBlank: false
    	}
		]
    },
	{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('EYE_COLOR'),
			name: 'eyeColor',
			store: 'common.ColorStore',
			valueField: 'id',
			displayField: 'value',
			queryMode: 'remote',
			editable: false
		},
		{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('HAIR_COLOR'),
			name: 'hairColor',
			store: 'common.ColorStore',
			valueField: 'id',
			displayField: 'value',
			queryMode: 'remote',
			editable: false
		}
		]
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            name: 'updatedDate',
            itemId: 'updatedDate',
            width : 200,
          //--submitFormat:CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			allowBlank:false,
            fieldLabel: getPersonModuleTranslation('PHYSICAL_CHAR_DATE')
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
    
 

    
});
