/**
 *  @Dharmendra.Prajapati
 *  Research Type Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.ResearchTypeGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.researchtypegrid',
    title: getPersonModuleTranslation('RESEARCH_TYPE'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [/*{
        header: getPersonModuleTranslation('ACTIVITY_TYPE'),
        dataIndex: 'activityType',
        sortable:true,
        flex: .2,
        renderer : function(obj){
        	return columnObjRender(obj, "value");
        }
    }, */{
        header: getPersonModuleTranslation('RESEARCH_TYPE1'),
        dataIndex: 'researchType',
        sortable: true,
        flex: .2,
        renderer : function(obj){
        	return columnObjRender(obj, "value");
        }
    }, {
        header: getPersonModuleTranslation('RESEARCH_TITLE'),
        dataIndex: 'researchTitle',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('RESEARCH_DATE'),
        dataIndex: 'researchDate',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('PUBLICATION_YEAR'),
        dataIndex: 'yearOfPublication',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getPersonModuleTranslation('AUTHOR'),
        dataIndex: 'authorName',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('JOURNAL_TYPE'),
        dataIndex: 'conferenceJournalType',
        sortable:true,
        flex: .2,
        renderer : function(obj){
        	return columnObjRender(obj, "value");
        }
    },{
        header: getPersonModuleTranslation('PROJECT_TYPE'),
        dataIndex: 'projectType',
        sortable:true,
        flex: .2,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return record.data.projectType;
			}
		}
    },{
        header: getPersonModuleTranslation('DOCUMENT'),
        dataIndex: 'noOfdocument',
        sortable:true,
        flex: .2,
        renderer : function(val){
        	if (!isNullOrEmpty(val) && val > 0) {
        		return '<a href="#">'+val+'</a>';
        	}
		}
    },{
        header: getPersonModuleTranslation('PAGE_NO'),
        dataIndex: 'pageNumber',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('VOLUME_NO'),
        dataIndex: 'volumeNo',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('ISSUE_NO'),
        dataIndex: 'issueNo',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('JOURNAL_NAME'),
        dataIndex: 'journalName',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('PUBLISHER_NAME'),
        dataIndex: 'publisherName',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('RESEARCH_GROUP'),
        dataIndex: 'researchGroup',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('LINK_URL'),
        dataIndex: 'url',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('FUNDING_AGENCY_NAME'),
        dataIndex: 'fundingAgencyName',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('FUND_TYPE'),
        dataIndex: 'fundType',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('TENURE'),
        dataIndex: 'tenure',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('INSTITUTE_AFFILIATION'),
        dataIndex: 'whetherInstituteAffiliation',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('UC_SUBMITTED'),
        dataIndex: 'whetherUCSubmitted',
        sortable:true,
        hidden:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('DATE_OF_UC_SUBMISSION'),
        dataIndex: 'dateOfUCSubmission',
        sortable:true,
        hidden:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getPersonModuleTranslation('IMPACT_FACTOR'),
        dataIndex: 'impactFactor',
        sortable:true,
        hidden:true,
        flex: .2
    }
    
    
    
    /* {
        header: getPersonModuleTranslation('PARTICIPATE'),
        dataIndex: 'isCurrentOrganization',
        sortable:true,
        flex: .2,
        renderer : function(value){
        	var msg = "";
        	if(value == true){
        		msg = getPersonModuleTranslation('AFTER_JOINING');
        	}else{
        		msg = getPersonModuleTranslation('PRIOR_TO_JOINING');
        	}
        	
        	return msg;
        }
    }*/],

 initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.ResearchTypeGridStr');
    }

});	