Ext.define('Academia.view.personinfo.common.pasthistory.TrainingFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.trainingformwindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getPersonModuleTranslation('TRAINING_DETAILS'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'trainingForm',
        items: [{
            xtype: 'hidden',
            itemId: 'training_hidden_field',
            name: 'id'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('TRAINING_NAME'),
                
                name: 'trainingName',
                allowBlank: false
            }, {
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('CATAGORY_TRAINING'),
                
                name: 'catagory',
                valueField: 'id',
                displayField: 'value',
                //                store: 'common.ExperienceTypeStore',
                editable: false,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('FROM_DATE'),
                name: 'fromDate',
                allowBlank: false,
              //--submitFormat : CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                }
            }, {
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('To_Date'),
                name: 'toDate',
                allowBlank: false,
              //--submitFormat : CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'vbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('ORGANIZATION_TRANING'),
                
                name: 'organization',
                allowBlank: false
            }, {
                xtype: 'textareafield',
                width: 460,
                name: 'remark',
                fieldLabel: getPersonModuleTranslation('REMARK')
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'saveTrainingButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelTrainingButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]
    }]
});