/**
 * @author sachin.bangar Work Experience Form
 */
Ext.define('Academia.view.personinfo.common.pasthistory.WorkExperienceForm', {
    // extend: 'Ext.form.Panel',
    //extend: 'Academia.view.common.CustomFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.workexperienceform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    initComponent: function() {
    	        if(this.itemId==='applicantWorkExperienceForm'){
    	            Ext.apply(this,{
    	                customFieldEntity:CONSTANTS.APPLICANT_WORK_EXPERIENCE_CD,
    	                columns: 1
    	            });
    	           
    	        }    
    	        this.callParent(arguments);
    	    },
    listeners:{
    	beforeRender: function(){
    		if(this.itemId==='applicantWorkExperienceForm'){
    		    Ext.apply(this,{
    		    	customFieldEntity:CONSTANTS.APPLICANT_WORK_EXPERIENCE_CD,
        		    columns: 1
    		    });
    		   
    		}else if(this.itemId==='facultyWorkExperienceForm'){
    		    Ext.apply(this,{
    		    	customFieldEntity:CONSTANTS.WORK_EXPERIENCE_CD,
    		    	customFieldEntityType:CONSTANTS.EMPLOYEE_WORK_EXPERIENCE_CF_ENTITY_TYPE,
        		    columns: 1
    		    });
    		   
    		}else{
    			Ext.apply(this,{
    				customFieldEntity:CONSTANTS.WORK_EXPERIENCE_CD,
    				customFieldEntityType:CONSTANTS.STUDENT_WORK_EXPERIENCE_CF_ENTITY_TYPE,
            		columns:1
    			});
    		}
    	}
    },
    items: [{
        xtype: 'hidden',
        itemId: 'workexp_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
     items: [{
		  xtype: 'customcombobox',
		  fieldLabel: getPersonModuleTranslation('INDUSTRY'),
		  name: 'industry',
		  itemId: 'industryItemId',
		  editable: false,
          store: 'common.CSMIndustryStore',
          valueField: 'id',
          displayField: 'value'
		},{
		  xtype: 'textfield',
		  fieldLabel: getPersonModuleTranslation('AREA_OF_EXPERTISE'),
		  name: 'areaOfExpertise',
		  itemId: 'areaOfExpertise',
		  enforceMaxLength:true,
		  maxLength:100
		}]
     },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
     items: [{
         xtype: 'textfield',
         fieldLabel: getPersonModuleTranslation('EMPLOYER'),
         name: 'employer',
         allowBlank: false,
         itemId :'employerId'
        },{
		  xtype: 'customcombobox',
		  fieldLabel: getPersonModuleTranslation('DESIGNATION'),
		  name: 'designation',
		  itemId: 'designation',
		  editable: false,
          store: 'personinfo.common.pasthistory.WorkExperienceDesignationStore',
          valueField: 'value',
          displayField: 'value',
          value : '',
		}]
     },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
        },
        items:[{
			xtype: 'textfield',
			name: 'department',
			itemId:'departmentItemId',
			displayField:'name',
			allowBlank:true,
			width: 226,
			fieldLabel:getCommonTranslation('DEPARTMENT'),
        },{
   	   	 xtype : 'radiogroup',
   		 itemId:'currentOrgGroupId',
   		 name:'whetherCurrentOrg',
   	     defaults: {flex: 1},
   	     fieldLabel: getPersonModuleTranslation('CURRENT_COMPANY_OR_ORGANIZATION'),
   	     columns: 2,
   	     width: 226,
   	     vertical: false,
   	     layout: {
   	    	 type: 'hbox'
   	     },
   	     items : [{
   	   		 boxLabel : getCommonTranslation('YES'),
   	   		 name : 'whetherCurrentOrg',
   	   		 inputValue : true,
   	   		 checked : true   	   		 
   	   	 },{
   	   		 boxLabel : getCommonTranslation('NO'),
   	   		 name : 'whetherCurrentOrg',
   	   		 inputValue : false
   	   	 }]
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN'),
            itemId : "dateOfJoining",
            name: 'joiningDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype: 'daterange',
            endDateField:'exitDate',
            editable:false,
            maxValue: new Date()
        },{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_EXIT'),
            itemId : "exitDate",
            name: 'exitDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            vtype: 'daterange',
            startDateField:'dateOfJoining',
            editable:false,
            disabled:true,
            maxValue: new Date()
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'numberfield',
            fieldLabel: getPersonModuleTranslation('DURATION_OF_EMPLOYMENT_MONTHS'),
            itemId : 'durationInMonths',
            value : 0,
            minValue : 0,
            readOnly:true,
            decimalPrecision : 2,
            name: 'duration'
        },{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('MODE_OF_EMPLOYMENT'),            
            name: 'workType',
            itemId: 'workType',
            valueField: 'id',
            displayField: 'value',
            store: 'common.WorkTypeStore',
            allowBlank:false,
            editable: false,
            listeners: {
            	render: function(workType) {
            		workType.getStore().load({
            			callback: function(records, operation, success) {
            				workType.setValue(records[0].data.id);
            			}	   
            		});
            	}
           }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textareafield',
            name: 'jobProfile',
            itemId: 'jobProfile',
            width : 460,
            fieldLabel: getPersonModuleTranslation('JOB_PROFILE')
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
