/**
 * This view is used for the student, faculty credit Bills records.
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.CreditNoteGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.creditnotegrid',
	title: getCommonTranslation('BILL_PAYABLE'),
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: false
	},
	selType : 'checkboxmodel',
	selModel : {
		mode : 'MULTI',
		showHeaderCheckbox : true,
		allowDeselect : true,
		checkOnly : true,
		renderer : function(value, metaData, record, rowIndex,
				colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix
			+ 'grid-cell-special ' + baseCSSPrefix
			+ 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix
			+ 'grid-row-checker">&#160;</div>';
		}
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnStudentPrintTaxCertificatePortal',
		text : getFeeAndPaymentCommonTranslation('PRINT_TAX_CERTIFICATE'),
		tooltip: getFeeAndPaymentCommonTranslation('PRINT_TAX_CERTIFICATE')
	},'->',{
		xtype: 'button',
		itemId: 'btnPrint',
		disabled : true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}],
	initComponent: function() {
		var studentPaymentController =Academia.app.getController('Academia.controller.personinfo.student.StudentPaymentRefundController');
		var portalId = studentPaymentController.getCurrentLoggedPortalId();
		var this$ = this;
		var columnArray = new Array();

		if(!Ext.isDefined(this$.isContained))
		{  if(portalId == 1){
			if(Ext.isDefined(Ext.ComponentQuery.query('debitnoteandcreditnotepanel')))
			{
				this$.isContained = Ext.ComponentQuery.query('debitnoteandcreditnotepanel')[0];
			}
		}else if(portalId ==3 ){
			if(Ext.isDefined(Ext.ComponentQuery.query('pendingbillstructure')))
			{
				this$.isContained = Ext.ComponentQuery.query('pendingbillstructure')[0];
			}			
		}
		else if(portalId == 7){
			if(Ext.isDefined(Ext.ComponentQuery.query('debitnoteandcreditnotestructureparentportal')))
			{
				this$.isContained = Ext.ComponentQuery.query('debitnoteandcreditnotestructureparentportal')[0];
			}
		  }

		}

		if(this$.isContained != undefined){
			if(this$.isContained.personType == 'STUDENT' || this$.isContained.personType == 'APPLICANT' || this$.personType == 'APPLICANT' || this$.personType == 'STUDENT' ){
				columnArray = this$.getStudentPendingBillsGridColumn();
			}else if(this$.isContained.personType == 'FACULTY' || this$.personType == 'FACULTY' || this$.personType == 'USER'){
				columnArray = this$.getFacultyPendingBillsGridColumn();
			}
		}else{
			if(this$.personType == 'APPLICANT' || this$.personType == 'STUDENT' || this$.personType == 'USER'){
				columnArray = this$.getStudentPendingBillsGridColumn();
			}else if(this$.isContained.personType == 'FACULTY' || this$.personType == 'FACULTY' ){
				columnArray = this$.getFacultyPendingBillsGridColumn();
			}
		}

		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			columns: columnArray,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$,false);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.paymentandrefund.PendingBillStore');
	},
	/**
	 * Column array for student pending bills
	 */
	getStudentPendingBillsGridColumn: function(){
		var columnArray = new Array();
		columnArray = [{
			header: getCommonTranslation('CREDIT_NOTE_NO'),
			dataIndex: 'billNo',
			sortable: true,
			flex: .2,
			renderer: function(value, metaData, record, rowIndex, colIndex, view) {
				metaData.style = "white-space: normal;";
				return value;
			},
			summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
				if(portalId==1){
					if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
						return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.baseCurrencyName+")";
					} else {
						return getFeeAndPaymentCommonTranslation('TOTAL');
					}
				}else{
					if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
						return getFeeAndPaymentCommonTranslation('TOTAL');
					}
				}
			}
			/*summaryRenderer: function(value, summaryData, dataIndex) {
		          return getFeeAndPaymentCommonTranslation('TOTAL');
		      }*/
		},{
			header: getCommonTranslation('CREDIT_NOTE_DATE'),
			dataIndex: 'billDate',
			flex: .2,
			renderer:function(value,meta){
				if(!isNullOrEmpty(value)) {
					return dateRender(value);
				}
			}
		},{
			header: getPersonModuleTranslation('BILL_DUE_DATE'),
			dataIndex: 'dueDate',
			flex: .2,
			renderer:function(value,meta){
				if(!isNullOrEmpty(value)) {
					return dateRender(value);
				}
			}
		}, {
			header: getCommonTranslation('CREDIT_NOTE_TYPE'),
			dataIndex: 'raiseBillType',
			flex: .2,
			renderer: function(value){
				if(!isNullOrEmpty(value)){
					value = getCommonTranslation(value);
				}
				return value;
			}
		},{
			header: getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
			dataIndex: 'discount',
			flex: .2,
			summaryType: 'sum',



			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				if(portalId ==1){
					if(store.data.items[0].data.baseCurrencyId==null){
						return currencyRenderer(value,record.get("currencyId"));
					}
					return " ";
				}else{
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				//	return Ext.util.Format.currency(value,'',record.get("currencyId"),false);
				}
			}

			/*	
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				return  value;
			}*/
		},
		{

			header : getCommonTranslation('CURRENCY_EXCHANGE_RATE_DETAIL'),
			dataIndex : 'currencyExchangeRate',
			flex : .3,

		},
		{
			header: getCommonTranslation('BILL_ABLE_AMOUNT'),
			dataIndex: 'feeAmount',
			flex: .2,
			summaryType: 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				if(portalId ==1){
					if(store.data.items[0].data.baseCurrencyId==null){
						return currencyRenderer(value,record.get("currencyId"));
					}
					return " ";
				}else{
					//return currencyRenderer(value,record.get("currencyId"));
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}
			}

			/*	renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(value)){
						return currencyRenderer(value,record.get("currencyId"));
					}
				},
				align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
    			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
    				return  value;
    			}*/
		},{
			header : getFeeAndPaymentCommonTranslation('CONVERTED_AMOUNT'),
			dataIndex : 'convertedAmount',
			flex : .3,
			summaryType: 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("baseCurrencyId"));
				}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				//return Ext.util.Format.currency(value,'',record.get("baseCurrencyId"),false);
				//return Ext.util.Format.currency(value,'',store.data.items[0].data.baseCurrencyId,false);
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}

			/*renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(value)){
						//return currencyRenderer(value,record.get("currencyId"));
						return record.get("baseCurrencyCode") + " "+value;
					}
				}*/
		}, /*{
			header: getPersonModuleTranslation('BILL_VIEW'),
			dataIndex: 'billView',
			flex: .2
		} ,{
			header: getPersonModuleTranslation('BILL_GENERATION_TYPE'),
			dataIndex: 'billGenerationType',
			flex: .2
		},*/ {
			header: getPersonModuleTranslation('BALANCE_AMOUNT'),
			dataIndex: 'balanceAmount',
			flex: .2,
			summaryType: 'sum',/*//AS PER DISCUSSION WITH NAVIN SIR AND STORY-89564
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
				}
				},
				summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				//return Ext.util.Format.currency(value,'',record.get("currencyId"),false);
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}*/
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				if(portalId ==1){
					if(store.data.items[0].data.baseCurrencyId==null){
						return currencyRenderer(value,record.get("currencyId"));
					}
					return " ";
				}else{
					//return Ext.util.Format.currency(value,'',record.get("currencyId"),false);
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}
			}
		},{
			header : getFeeAndPaymentCommonTranslation('CONVERTED_BALANCE_AMOUNT'),
			dataIndex : 'convertedBalanceAmount',
			flex : .3,
			summaryType: 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("baseCurrencyId"));
				}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}
		}, {
			header: getCommonTranslation('CREDIT_NOTE_CURRENCY'),
			dataIndex: 'currencyName',
			flex: .2,
			hidden:true
		}];

		return columnArray;
	},
	/**
	 * Column array for faculty pending bills
	 */
	getFacultyPendingBillsGridColumn: function(){
		var columnArray = new Array();
		columnArray = [{
			header: getPersonModuleTranslation('BILL_NUMBER'),
			dataIndex: 'billNo',
			sortable: true,
			flex: .2,
			renderer: function(value, metaData, record, rowIndex, colIndex, view) {
				metaData.style = "white-space: normal;";
				return value;
			},
			summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
				if(portalId==1){
					if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
						return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.baseCurrencyName+")";
					} else {
						return getFeeAndPaymentCommonTranslation('TOTAL');
					}
				}else{
					if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
						return getFeeAndPaymentCommonTranslation('TOTAL');
					}
				}

			}
		},{
			header: getPersonModuleTranslation('BILL_DATE'),
			dataIndex: 'billDate',
			flex: .2,
			renderer:function(value,meta){
				if(!isNullOrEmpty(value)) {
					return dateRender(value);
				}
			}	
		}, {
			header: getPersonModuleTranslation('BILL_TYPE'),
			dataIndex: 'raiseBillType',
			flex: .2,
			renderer: function(value){
				if(!isNullOrEmpty(value)){
					value = getCommonTranslation(value);
				}
				return value;
			}
		},{
			header: getCommonTranslation('BILL_ABLE_AMOUNT'),
			dataIndex: 'billAmount',
			flex: .2,
			summaryType: 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)) {
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				if(portalId ==1){
					if(store.data.items[0].data.baseCurrencyId==null){
						return currencyRenderer(value,record.get("currencyId"));
					}
					return " ";
				}else{
					return Ext.util.Format.currency(value,'',record.get("currencyId"),false);
				}
			}

		},
		{
			header: getCommonTranslation('CURRENCY_EXCHANGE_RATE_DETAIL'),
			dataIndex: 'currencyExchangeRate',
			flex: .2,	
		},{
			header : getFeeAndPaymentCommonTranslation('CONVERTED_AMOUNT'),
			dataIndex : 'convertedAmount',
			flex : .3,
			summaryType: 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("baseCurrencyId"));
				}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}
		},{
			header: getCommonTranslation('CREDIT_NOTE_CURRENCY'),
			dataIndex: 'billCurrency',
			flex: .2,
			hidden:true
		}];

		return columnArray;
	}
});