/**
 * @Author Surendra Jha  
 */
Ext.define('Academia.view.personinfo.common.personalinfo.IdentityDetailsGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.identitydetailsgrid',
	title: getPersonModuleTranslation('IDENTITY_DETAILS'),
	border: true,
	isGridConfigurable: true,
	viewConfig: {
		stripeRows: true
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],

	columns: [{
		header: getPersonModuleTranslation('ID_TYPE'), 
		dataIndex: 'identityType',
		sortable:true,
		flex: .2,
		renderer : function(obj){
			return columnObjRender(obj, "value");
		}
	}, {
		header: getPersonModuleTranslation('ID_NUMBER'), 
		dataIndex: 'idNumber',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('ISSUING_AUTHORITY'), 
		dataIndex: 'issuingAuthority',
		sortable:true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('COUNTRY_NAME'), 
		dataIndex: 'country',
		sortable:true,
		hidden : true,
		flex: .2,
		renderer : function(obj){
			return columnObjRender(obj, "value");
		}
	}, {
		header: getPersonModuleTranslation('ISSUED_PLACE'), 
		dataIndex: 'issuedPlace',
		sortable:true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('ISSUED_DATE'),
		dataIndex: 'studentIssuedDate',
		sortable:true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('VALIDTILL_DATE'), 
		dataIndex: 'studentValidTillDate',
		sortable:true,
		flex: .2
	}, {
        header:getCommonTranslation('ACTUAL_FOLLOW_UP_DATE'),
        dataIndex: 'studentActualFollowUpDate',
        sortable: true,
        flex: .2
    },{
		header: getPersonModuleTranslation('DOCUMENT'),
		dataIndex: 'documents',
		sortable:true,
		flex: .2,
		 renderer : function(val){
	        if (!isNullOrEmpty(val) && val.length > 0) {
	        	return '<a href="#">'+val[0].name+'</a>';
	        }
		}
	}, {
		header: getCommonTranslation('IDENTITY_TYPE_URL'),
		dataIndex: 'documentUrl',
		sortable:true,
		flex: .2,
		renderer:function(val, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(val)){
				return '<a href='+val+' target="_blank">'+record.data.identityType.value+'</a>';
			}	
		}
	}],
    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.personalinfo.IdentityDetailsStore');
    }
});