/**
 * @author Amit G
 * 
 */
Ext.define('Academia.view.personinfo.common.personalinfo.LivingArrangementDetailsForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.livingarrangementdetailsform',
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	title: getCommonTranslation('LIVING_ARRANGEMENT'),
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	items : [{
		xtype: 'hidden',
		name: 'id'
	},{
        xtype: 'hidden',
        itemId:'filePath',
        name: 'filePath'
    },{
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
            name: 'livingArrangement',
            itemId: 'livingArrangementId',
            fieldLabel: getCommonTranslation('LIVING_ARRANGEMENT'),
            store: Ext.create('Academia.store.student.studentprofile.LivingArrangementTypeStore'),
            valueField: 'id',
            allowBlank: false,
            displayField: 'value',
            forceSelection: true,
            editable: false
		},{
			xtype : 'textfield',
			name : 'roomAllocation',
			itemId:'roomAllocationId',
			maxLength:100,
			fieldLabel : getCommonTranslation('ROOM_ALLOCATION'),
			allowBlank:true
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'textarea',
			name:'address',
			itemId:'address',
			allowBlank:true,
			width: 460,
			maxLength : 250,
			fieldLabel: getCommonTranslation('ADDRESS')
		}]    
	
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
    		xtype: 'datefield',
    		fieldLabel: getCommonTranslation('START_MONTH'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype : 'daterange',
    		endDateField : 'endMonth',
    		name: 'startMonth',
    		allowBlank:false,
    		itemId: 'startMonth',
    	},{
    		xtype: 'datefield',
    		fieldLabel: getCommonTranslation('END_MONTH'),
    		startDateField : 'startMonth',
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		//--submitFormat : CONSTANTS.DATE_FORMAT,
    		vtype : 'daterange',
    		name: 'endMonth',
    		allowBlank:false,
    		itemId: 'endMonth',
    	}]
	
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		itemId:'accommodationProviderContainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
            name: 'accommodationProvider',
            itemId: 'accommodationProviderId',
            fieldLabel: getCommonTranslation('ACCOMMODATION_PROVIDER'),
            store: 'student.studentprofile.LivingArrangementAccommodationStore',
            valueField: 'id',
            allowBlank: true,
            displayField: 'accommodProviderName',
            editable: false, 
            listConfig:{
            listeners: {
                beforeshow: function(picker) {
                    picker.width = picker.up('combobox').getSize().width;
                }
            }
            }
		},{
			xtype : 'textfield',
			name : 'providerName',
			itemId:'providerNameId',
			maxLength : 255,
			fieldLabel : getCommonTranslation('PROVIDER_NAME'),
			//readOnly:true,
			allowBlank:true
		},{
			xtype: 'textfield',
			name:'providerContactdetails',
			itemId:'providerContactdetailsId',
			allowBlank:true,
			maxLength : 20,
			//readOnly:true,
			fieldLabel: getCommonTranslation('PROVIDER_CONTACT_DETAILS')
		}]
	
	},{

		xtype : 'fieldcontainer',
		width : '100%',
		itemId:'providerAddressContainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'textarea',
			name:'providerAddress',
			itemId:'providerAddressId',
			allowBlank:true,
			readOnly:true,
			width: 460,
			maxLength : 255,
			fieldLabel: getCommonTranslation('PROVIDER_ADDRESS')
		}]    
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		itemId:'paymentContainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'numberfield',
			fieldLabel: getCommonTranslation('COST'),
			name: 'cost',
			itemId: 'costId',
			maxLength: 7,
			minValue : 0,
			allowBlank:true,
			allowExponential :false,
            allowDecimals: false
		},{
			 xtype      : 'radiogroup',
			 fieldLabel : getCommonTranslation('DIRECT_PAYMENT'),
			 itemId: 'directPaymentId',
			 width:300,
			 name: 'directPayment',
			 disabled:true,
			 layout: 'hbox',
			 items:[{ 
				 boxLabel: getCommonTranslation('YES'), 
				 name: 'isDirectPayment', 
				 inputValue: true
			 },{ 
				 boxLabel: getCommonTranslation('NO'), 
				 name: 'isDirectPayment', 
				 inputValue: false,
				 checked:true
			 }]
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		itemId:'fileContainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'filefield',
            fieldLabel: getCommonTranslation('LEASE_AGREEMENT'),
            buttonText: getPersonModuleTranslation('BROWSE'),
            itemId: 'leaseAgreement',
            ui: 'CustomBtnSubmit',
            name: 'file',
            width: 226,
            labelAlign: 'top',
            allowBlank:true,
            listeners: {
                specialkey: function(me, e) {
                    if (e.getKey() == e.TAB) {
                        e.stopEvent();
                    }
                }
            }
		},
		{

			xtype: 'displayfield',
			itemId: 'availableLivingDocItemId',
			name:'availableLivingDoc',
			 style: {
		            marginTop: '24px',
		        },
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					var pathSplit=value.split('/');
	                var documentName=pathSplit[2];
					return '<a href=#>'+documentName+'<a>';
							}
			},
			listeners: {
				afterrender: function(c){
	    			c.getEl().on('click', function(e){
	    				if(e.target.tagName=='A') {
	    				var path = this.up('livingarrangementdetailsform').down('#availableLivingDocItemId').getValue();
	    				if(!isNullOrEmpty(path)) {
	    	       		var csvForm = Ext.create('Ext.form.Panel'); 
	    	       		csvForm.getForm().submit({
	    	       			target: '_blank',
	    	       			method:'POST',
	    	       			params :{
	    	       				access_token : Ext.Ajax.defaultHeaders.access_token,
	    	       				path: path
	    	       			},
	    	       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	    	       			url: SERVERURL.PATH_FILE_DOWNLOAD_API,
	    	       			standardSubmit :true
	    	       		});
	    				}
	    				}
	    			}, c);
	    		}
	    	}
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE') ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}]
	}]
});