/**
 * Faculty Family Detail Grid 
 */
Ext.define('Academia.view.personinfo.faculty.familydetail.FacultyFamilyDetailGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.facultyfamilydetailgrid',
    title: getPersonModuleTranslation('FAMILY_DETAILS'),
    border: true,
    height:50,
    cls: 'exportBtnVisibleGrid',
    //autoScroll: true,
    viewConfig: {
        stripeRows: true,
        loadMask:false
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:false
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:false
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    },'->',{
		xtype: 'splitbutton',
		itemId: 'btnExportToPDFJasper',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-pdf-icon',
		menu: [{
			text: 'Export Current Page',
			itemId: 'exportPDFCurrentPage'
		}]
	},{
		xtype: 'splitbutton',
		itemId: 'btnExportToExcelJasper',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-excel-icon',
		menu: [{
			text: 'Export Current Page',
			itemId: 'exportExcelCurrentPage'
		}]
	}],
    columns: [{
    	header: getPersonModuleTranslation('PROFILE_PIC'),
        dataIndex: 'photoUrl',
        sortable:false,
        flex:.08,
        renderer: function(value, metaData) {
        	metaData.tdAttr = 'type="gridImageCell"';
        	if(!isNullOrEmpty(value) && value !=0){
        		var extensionArr = value.split(".");
        		var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
        		value='<img src="'+imageUrl+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px;">';
        		return value;
        	}else{
        		var imageUrl="resources/images/profile_faculty.png";
        		value='<img src="'+imageUrl+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px">';
        		return value;
        	}
        }
    },{
    	header: getPersonModuleTranslation('USER_CODE'),
        dataIndex: 'parentUserCode',
        sortable: true,
        flex: .2,
        hidden:true
    },{
        header: getPersonModuleTranslation('RELATIONSHIP'),
        dataIndex: 'relationship',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	relationshipCheck=this.getStore().data.items[0].data.relationshipCheck;
        	if(relationshipCheck){
        		if(value=='FATHER'){
        			return getPersonModuleTranslation('FATHER');
        		}else{
        			if(value == 'MOTHER'){
        				return getPersonModuleTranslation('MOTHER');
        			}else{
        				if(value == 'SPOUSE'){
        				return getPersonModuleTranslation('SPOUSE');
        				}
        				else{
        					if(value == 'CHILD'){
        						return getPersonModuleTranslation('CHILD');
        					}
        				}
        			}
        		}
        	}else{
        	return getPersonModuleTranslation(value);
        	}
        }
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'relatedPerson',
        sortable: true,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, "value");
        }
    }, {
        header: getPersonModuleTranslation('EMAIL_ID'),
        dataIndex: 'relatedPersonEmailId',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('MOBILE_NO'),
        dataIndex: 'relatedPersonMobile',
        sortable: true,
        flex: .2
    },{
        header: getCommonTranslation('ALTERNATE_MOBILE_NO'),
        dataIndex: 'relatedPersonAlternateMobile',
        sortable: true,
        flex: .2
    },{
        header: getCommonTranslation('IS_EMERGENCY_CONTACT'),
        dataIndex: 'isEmergencyContact',
        sortable: true,
        hidden:true,
        flex: .2,
        renderer: function(value) {
			 if(value==true){
				 return 'Yes';
			 }else{
				 return 'No';
			 }    			 
		 	}     
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        try{
        	setTimeout(function(){
        		try{
        			this$.down('#btnExportToPDF').show();
        			this$.down('#btnExportToExcel').show();
        			this$.down('#btnExportToPDFJasper').hide();
        			this$.down('#btnExportToExcelJasper').hide();
        			if(this$.down('#btnExportToExcelJasper').nextSibling().xtype=="tbfill"){
        				this$.down('#btnExportToExcelJasper').nextSibling().show();
        			}
        		}
        		catch(e){

        		}
        	},100);
        }
        catch(e){
        	
        }
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.personalinfo.FacultyFamilyDetailStore');
    }
});
