/**
 *  Vyabha.thakur
 */

Ext.define('Academia.view.personinfo.student.ChangePrimaryLocation', {
    extend: 'Ext.window.Window',
    alias: 'widget.changeprimarylocation',
    title: getCommonTranslation('CHANGE_ACADEMY_LOCATION'),
    border : false,
	frame : false,
	modal: true,
    items: [{
		xtype: 'form',
		method : 'POST',
		itemId:'changeprimarylocationId',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit : false,
	items: [ {
        xtype: 'hidden',
        itemId: 'id',
        name: 'id'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'customcombobox',
			name: 'reassignTo',
			itemId:'reassignTo',
			fieldLabel: getCommonTranslation('REASSIGN_TO'),
			store:'user.UserPrimaryLocation',
			displayField:'value',
			valueField:'id',
			allowBlank:false,
			typeAhead : false,
            forceSelection:true,
            hideTrigger:false,
            queryMode: 'remote',
            queryParam: 'qry',
    	    triggerAction: 'all',
    	    matchFieldWidth:true,
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
			
		},{
			xtype: 'datefield',
    		name: 'reassignmentDate',
    		itemId:'reassignmentDate',
    		fieldLabel: getCommonTranslation('REASSIGNMENT_DATE'),
    		maxValue: new Date(),
			allowBlank:true,
			listeners: {
    			 render: function(obj) {
                     obj = dateFormatRender(obj);
                     obj.setValue(new Date());
                 }
    		}
			
		}]
    }, {
    	xtype: 'fieldcontainer',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]
}]
});