/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.student.HoldSubCategoryDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.holdsubcategorydetailwin',
	title: getCommonTranslation('HOLD_SUB_CATEGORY'),
	frame: true,
	autoScroll:true,
	modal:true,
	height:360,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'managesubholdwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226,
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'manageSubHoldId',
			itemId: 'manageSubHoldId'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'holdSubCatCode',
				itemId:'holdSubCatCode',
				fieldLabel: getCommonTranslation('HOLD_SUB_CATEGORY_CODE'),
				allowBlank: false,
			},{
				xtype: 'textfield',
				name: 'holdSubCatName',
				itemId:'holdSubCatName',
				fieldLabel: getCommonTranslation('HOLD_SUB_CATEGORY_NAME'),
				allowBlank: false,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'applyHoldAt',
				itemId:'applyHoldAt',
				fieldLabel: getCommonTranslation('APPLY_HOLD_AT'),
				allowBlank: false,
				valueField: 'id',
				displayField: 'value',
				store:'student.managehold.ManageHoldApplyAtStore',
				typeAhead:true,
				forceSelection:true,
				newHoldTypes: [
                    'MAKRSHEET_PUBLISH',
                    'ASSESSMENT_SCHEME_LEVEL',
                    'ASSESSMENT_SCHEME_TYPE_LEVEL',
                    'ASSESSMENT_SCHEME_SUBTYPE_LEVEL',
                    'METHOD_LEVEL',
                    'EVENT_LEVEL',
                    'GRADEBOOK_PUBLISH',
                    'COMMUNICATION_HOLD',
                ],
                addedHoldTypes: [],
                listConfig: {
                	listeners: {
                		beforeshow: function (picker) {
                			picker.minWidth = picker.up('combobox').getSize().width;
                			if (picker.up) {
                				var combo = picker.up('combobox');
                				var comboStore = combo.getStore();
                				var allItems = picker.all.elements;
                				var holdVals = combo.addedHoldTypes;
                				if(!isNullOrEmpty(holdVals) && Ext.isArray(holdVals)) {
                					var indexes = getAllIndexes(holdVals, "");
                					for(var cnt = 0; cnt < indexes.length; cnt++) {
                						holdVals.splice(indexes[cnt], 1);
                					}
                				}
                				Ext.each(allItems, function (currentItem) {
                					var currentHoldTypeId = currentItem.viewRecordId;
                					var currentHoldTypeRecord = comboStore.findRecord('id', currentHoldTypeId);
                					if (holdVals.indexOf('RESULT_PUBLISH') != -1 && Ext.Array.contains(combo.newHoldTypes, currentHoldTypeRecord.get('id'))) {
                						currentItem.classList.add("disabledComboItem");
                					} else {
                						for(var i = 0; i < holdVals.length; i++) {
                							if(Ext.Array.contains(combo.newHoldTypes, holdVals[i]) && currentHoldTypeRecord.get('id') == 'RESULT_PUBLISH') {
                								currentItem.classList.add("disabledComboItem");
                							}
                							else {
                								currentItem.classList.remove("disabledComboItem");
                							}
                						}
                					}
                				});
                			}
                		},
                		refresh: function (boundList, eOpts) {
                			if (boundList.up) {
                				var combo = boundList.up('combobox');
                				var comboStore = combo.getStore();
                				var allItems = boundList.all.elements;
                				var holdVals = combo.addedHoldTypes;
                				if(!isNullOrEmpty(holdVals) && Ext.isArray(holdVals)) {
                					var indexes = getAllIndexes(holdVals, "");
                					for(var cnt = 0; cnt < indexes.length; cnt++) {
                						holdVals.splice(indexes[cnt], 1);
                					}
                				}
                				Ext.each(allItems, function (currentItem) {
                					var currentHoldTypeId = currentItem.viewRecordId;
                					var currentHoldTypeRecord = comboStore.findRecord('id', currentHoldTypeId);
                					if (holdVals.indexOf('RESULT_PUBLISH') != -1 && Ext.Array.contains(combo.newHoldTypes, currentHoldTypeRecord.get('id'))) {
                						currentItem.classList.add("disabledComboItem");
                					} else {
                						for(var i = 0; i < holdVals.length; i++) {
                							if(Ext.Array.contains(combo.newHoldTypes, holdVals[i]) && currentHoldTypeRecord.get('id') == 'RESULT_PUBLISH') {
                								currentItem.classList.add("disabledComboItem");
                							}
                							else {
                								currentItem.classList.remove("disabledComboItem");
                							}
                						}
                					}
                				});
                			}
                		}
                	}
                }
			},{
				xtype: 'customcombobox',
				name: 'holdSubCatStatus',
				itemId:'holdSubCatStatus',
				fieldLabel: getCommonTranslation('STATUS'),
				store:Ext.create('Academia.store.common.StatusComboStore'),
				valueField: 'value',
				displayField: 'name',
				allowBlank: false,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'autoApplyHold',
				itemId:'autoApplyHold',
				fieldLabel: getCommonTranslation('AUTO_APPLY_HOLD_BUSINESS_RULE'),
			},{
				xtype: 'customcombobox',
				name: 'autoRemoveHold',
				itemId:'autoRemoveHold',
				fieldLabel: getCommonTranslation('AUTO_REMOVE_HOLD_BUSINESS_RULE'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'radiogroup',
				itemId: 'authorizationBasis',
				name: 'authorizationBasis',
				fieldLabel: getCommonTranslation('AUTHORIZATION_BASIS'),
				columns: 2,
				vertical: false,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getCommonTranslation('ROLE'),
					name: 'authorizationBasis',
					itemId: 'authorizationBasisRole',
					width: 120,
					inputValue: false,
					checked: true
				}, {
					boxLabel: getCommonTranslation('USER'),
					name: 'authorizationBasis',
					itemId: 'authorizationBasisUser',
					width: 90,
					inputValue: true 
				}]
			},{
				xtype:'panel',
				defaults: {
					labelAlign: 'top',
					width: 226,
				},
				items:[{
					xtype: 'multiselectcombofield',
					cls:'multiBrandCampusCls',
					name: 'listOfRole',
					itemId:'listOfRole',
					valueField: 'id',
					displayField: 'value',
					cls:'commonAutoHeightMultiselectField',
					fieldLabel: getCommonTranslation('LIST_OF_ROLE'),
					store:'student.managehold.ManageHoldRolesStore',
					allowBlank: false,
					typeAhead : true,
				},{
					xtype: 'multiselectcombofield',
					cls:'multiBrandCampusCls',
					name: 'listOfEmp',
					itemId:'listOfEmp',
					cls:'commonAutoHeightMultiselectField',
					store:'student.managehold.ManageHoldStaffNameCode',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'codeOrName',
					fieldLabel: getCommonTranslation('LIST_OF_EMPLOYEE'),
					hidden: true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							}
						}
					}
				}]
			}]
		},{
			xtype:'fieldcontainer',
			fieldLabel: getCommonTranslation('VISIBLE_TO'),
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'checkbox',
				name:'parentPortal',
				itemId:'parentPortal',
				checked: true,
				boxLabel:getCommonTranslation('PARENT_PORTAL')
			},{
				xtype:'checkbox',
				name:'studentPortal',
				itemId:'studentPortal',
				cls:'stdPortalRadioButtonCls',
				checked: true,
				boxLabel:getCommonTranslation('STUDENT_PORTAL')
			}]},{
				xtype:'fieldcontainer',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtnHoldSubCategory',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtnHoldSubCategory',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]	
});