Ext.define('Academia.view.personinfo.student.RecentVisitedStudentProfile', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.recentvisitedstudentprofile',    
    title: getCommonTranslation('RECENT_VISITED_STUDENTS'), 
    frame: true,
    cls: "recentVisitedProfile",    
    header: {
        style: {
            'background': '#fff',
        }
    },
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    items: [
        {
            xtype: 'dataview',
            itemId: 'recentVisitedStudentId',
            cls: "recentVisitedProfileDataView", 
            store: 'studentCurrentProfileView.RecentVisitedStudentProfileStore',
            itemTpl: new Ext.XTemplate(
                '<div class="recentVistedBox">',
                    '<div class="recentVistedImgBox">',
                        '<tpl if="imageURL">',
	                        '<img src="{[this.getFullImagePath(values.imageURL)]}" alt="{firstName} {lastName}" class="profile-img"'+
	                        'onerror="this.onerror=null; this.src=\'{[generateInitialsImage(values.firstName, values.middleName, values.lastName)]}\'" '+
	                        'height="40" width="40" alt="Round Image">',
                        '<tpl else>',
                            '<img src="{[generateInitialsImage(values.firstName, values.middleName, values.lastName)]}" alt="{firstName} {lastName}" class="profile-img">',
                        '</tpl>',
                    '</div>',
                    '<div class="recentVistedInfo">',
                        '<div class="name">{firstName} {lastName}</div>',
                        '<div class="recentVistedId"><a href="#" class="open-profile-link"' +
                        'data-usercode="{userCode}" ' +
                        'data-admissionId="{admissionId}" ' +
                        'data-studentPersonId="{studentPersonId}" ' +
                        'data-programBatchSeatTypeConfigId="{programBatchSeatTypeConfigId}" ' +
                        'data-visitedStudentId="{visitedStudentId}" ' +
                        '>{userCode}</a></div>',
                    '</div>',
                '</div>',
                {
                    getFullImagePath: function (imageURL) {
                    	var extensionArr = imageURL.split(".");
                    	var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
                        return imageUrl;
                    }
                }
            )
        },
        {
            xtype: 'container',
            itemId: 'NoRecordFoundContainer',
            hidden: true,
            layout: {
                type: 'vbox',
                align: 'center'
            },
            style:{
                padding: '65px 0',
            },
            items: [
                {
                    xtype: 'image',
                    itemId: 'NoRecordFoundImgItemId',
                    src: 'resources/images/NoRecordFound.gif'
                },
                {
                    xtype: 'label',
                    itemId: 'NoRecordFoundLabel',
                    text: 'No Records Found',
                    style: {
                        textAlign: 'center',
                        marginTop: '5px',
                        color: '#808080',
                        fontWeight: '600',
                        fontSize: '14px'
                    }
                }
            ]
        }
    ]
});