/**
 * @author Amit G
 */
Ext.define('Academia.view.personinfo.student.StudentPWConditionsAdminAdmDocumentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.studentpwconditionsadminadmdocumentgrid',
    title: getCommonTranslation('LIST_OF_APPLICABLE_DOCUMENTS'),
    border: true,
    autoScroll: false,
    columnLines : true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	tbar: [{
		xtype: 'button',
		itemId: 'btnUploadDocument',
		hidden:true,
		text: getAdmissionTranslation('UPDATE_DOCUMENTS'),
		tooltip: getAdmissionTranslation('UPDATE_DOCUMENTS'),
		buttonAlign: 'left',
	}],
    columns: [ {
    	xtype: 'rownumberer',
        header: getCommonTranslation('SNO'),
        dataIndex: 'sNO',
        sortable: true,
        align: 'center',
        flex: .1
    }, {
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'documentTypeValue',
        //align: 'center',
        sortable: true,
        flex: .2
    }, {
        header: getAdmissionTranslation('UPLOADED'),
        dataIndex: 'documentStatusCSMValue',
        //align: 'center',
        sortable: true,
        flex: .2,
        renderer : function(value, metadata, record){
        	if(value == 'Pending'){
        		return 'No';
        	}else{
        		return 'Yes';
        	}
			
		}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.document.StoAdmDocumentConditionProgramAPPStore');
    }
});