var studentProfileTemplate = new Ext.XTemplate(
    '<tpl for=".">',
	    '<div class="std-info-box-wrapper">',
		    '<div class="std-info-box" style="display: grid;grid-template-columns: repeat(6, auto);gap: 10px;">',

		        '<div class="std-info-item student-name" style="color: #000000;margin-left: 0;">{name}<br><span class="student-number" style="font-weight:600;color: #000000;">{contactNumber}</span></div>',
		        '<div class="std-info-item" style="color: #000000;">Admission ID<br><span class="student-admissionCode" style="font-weight:600;color: #000000;">{admissionCode}</span></div>',
		        '<div class="std-info-item" style="color: #000000;">Program<br><span class="student-program" style="font-weight:600;color: #000000;">{program}</span></div>',
		        '<div class="std-info-item" style="color: #000000;">Batch<br><span class="student-batch" style="font-weight:600;color: #000000;">{batch}</span></div>',
		        '<div class="std-info-item" style="color: #000000;">Period<br><span class="student-period" style="font-weight:600;color: #000000;">{period}</span></div>',

		        '<div class="std-info-item"></div>',
		        '<div class="std-info-item" style="color: #000000;">Email ID<br><span class="student-email" style="font-weight:600;color: #000000;">{email}</span></div>',
		        '<div class="std-info-item" style="color: #000000;">Student ID <br> <a href="#" class="open-profile-link" style="color:#007bff;text-decoration: none;"'+
		        'data-usercode="{studentCode}" ' +
		         'data-studid="{studId}" ' +
		         'data-admissionId="{admissionId}" ' +
                'data-studentPersonId="{personId}" ' +
                'data-programBatchSeatTypeConfigId="{progBatchSeatConfigId}" ' +
                'data-visitedStudentId="{visitedStudentId}" ' +
		        '>{studentId}</a></div>',
		        '<div class="std-info-item" style="color: #000000;">Section <br><span class="student-section" style="font-weight:600;color: #000000;">{section}</span></div>',
		        '<div class="std-info-item" style="color: #000000;">Seat Type<br><span class="student-seatType" style="font-weight:600;color: #000000;">{seatType}</span></div>',
		        '<div class="std-info-item" style="color: #000000;">Advisor Name<br><span class="student-advisor" style="font-weight:600;color: #000000;">{advisorName}</span></div>',
		        '<div class="std-info-item btn">',
		            '<a href="#" class="visit-profile-btn open-profile-link" style="background-color:#007bff; color:white; padding:5px 10px; border-radius:5px; text-decoration:none;"'+
		            'data-usercode="{studentCode}" ' +
		            'data-studid="{studId}" ' +
		            'data-admissionId="{admissionId}" ' +
	                'data-studentPersonId="{personId}" ' +
	                'data-programBatchSeatTypeConfigId="{progBatchSeatConfigId}" ' +
	                'data-visitedStudentId="{visitedStudentId}" ' +
		            '>Visit Profile</a>',
		        '</div>',
		    '</div>',
		    
		    '<div style="display: table; width: 100%; margin-bottom: 5px;">',
		        
		    '</div>',
	    '</div>',
    '</tpl>'
);

Ext.define('Academia.view.personinfo.student.StudentProfileViewFilter', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.studentprofileviewfilter',
    cls: 'noPaddingPanel SearchTabPanelWithRightTabs panelNoSpace horizontalScrollingFixed',
    bodyPadding: '10 10 0 11',
    frame: false,
    cls: 'customSearchPanel userProfileFilterBox',
    plugins: "formlabelrequired",
    style: {
        marginLeft: CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    defaults: {
        labelAlign: 'top',
    },
    height: "auto",
    items: [{
        xtype: 'customcombobox',
        fieldLabel: getCommonTranslation('STUDENT_PROFILE_DETAILS'),
        name: 'studentProfileId',
        width: 330,
        itemId: 'studentProfileIdItemId',
        minChars: 3,
        triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        valueField: 'id',
        displayField: 'valueCode',
        store: "feeandpayment.managebill.StudentAdmission",
        queryParam:'studentNameOrCode',
		typeAhead:false,
        enableKeyEvents  : 'true',
        listConfig: {
            listeners: {
                beforeshow: function(picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                }
            },
            loadingText: getCommonTranslation('SEARCHING'),
            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        }
    }, {
        xtype: 'panel',
        itemId: 'profileContainerId',
        style: {
            marginTop: '0px !important'
        },
        layout: {
            type: 'hbox'
        },
        hidden: true,
        width: '100%',
        items: [{
        	xtype: 'image',
			itemId: 'profile_image',
			border: 1,
			style: {
				borderColor: '#e0e0e0',
				borderStyle: 'solid',
				borderRadius: '50%',
				marginTop:'38px !important'
			},
			width: 64,
			height: 64,
			src: 'resources/images/default-profile.png',
        }, {
            xtype: 'panel',
            style: {
                marginTop: '25px !important',
                marginLeft: '20px !important',
            },
            width: '80%',
//            height: 100,
            items: [{
                xtype: 'dataview',
                itemId: 'studentProfileSearchComponent',
                tpl: studentProfileTemplate,
                store: Ext.create('Academia.store.feeandpayment.StudentDetailsByStudentAndAdmissionId'),
                data: {} 
            }]
        }]
    }]
});
