/**
 * Swapnil Patil
 * 
 */
Ext.define('Academia.view.personinfo.student.StudentProgressSearchForm', {
	extend : 'Ext.form.Panel',
	alias : 'widget.studentprogresssearchform',
	autoScroll: false,
	frame: false,
	refreshStoreData:true,
	cls:'customSearchPanel',
	style: {
		marginLeft: '0px !important',
		//marginLeft:'-10px !important'
	},
	plugins : "formlabelrequired",
	items : [ 
	         {
	        	 xtype : 'fieldcontainer',
	        	 width : 'auto',
	        	 layout : {
	        		 type : 'hbox'
	        	 },
	        	 defaults : {
	        		 width : 226,
	        		 labelAlign : 'top'
	        	 },
	        	 items : [ 
	        	          {
	        	        	  xtype: 'multiselectcombofield',
	        	        	  name: 'academyLocationIds',
	        	        	  itemId:'academyLocationIds',
	        	        	  fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
	        	        	  store:'common.AcademyLocationNameSeparated',
	        	        	  allowBlank : false,
	        	        	  valueField : 'id',
	        	        	  width:460,
	        	        	  maxLength : 1000,
	        	        	  displayField : 'value',
	        	        	  matchFieldWidth:true
	        	          }]
	         },{
	        	 xtype : 'fieldcontainer',
	        	 width : 'auto',
	        	 layout : {
	        		 type : 'hbox'
	        	 },
	        	 defaults : {
	        		 width : 226,
	        		 labelAlign : 'top'
	        	 },
	        	 items : [ 
	        	          {
	        	        	  xtype: 'customcombobox',
	        	        	  name: 'studentId',
	        	        	  itemId:'studentId',
	        	        	  fieldLabel: getCommonTranslation('STUDENT_NAME'),
	        	        	  store: Ext.create('Academia.store.feeandpayment.reports.StudentByPBSIntakeYear'),
	        	        	  valueField: 'id',
	        	        	  displayField: 'valueCode',
	        	        	  queryParam:'studentNameOrCode',
	        	        	  triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	        	        	  enableKeyEvents  : 'true',
	        	        	  minChars:3,
	        	        	  typeAhead:false,
	        	        	  forceSelection:true,
	        	        	  emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        	        	  triggerAction: '',
	        	        	  hideTrigger:false,
	        	        	  listConfig: {
	        	        		  listeners: {
	        	        			  beforeshow: function(picker) {
	        	        				  picker.minWidth = picker.up('combobox').getSize().width;
	        	        			  }
	        	        		  },
	        	        		  loadingText: getCommonTranslation('SEARCHING'),
	        	        		  emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        	        		  getInnerTpl: function() {
	        	        			  return '<div class="search-item">' +
	        	        			  '{studentCode} / {studentName}' +
	        	        			  '</div>';
	        	        		  }
	        	        	  }},
	        	        	  {
	        	                  xtype: 'statusCombo',
	        	                  name: 'STATUS',
	        	                  itemId:'status',
	        	                  fieldLabel: getCommonTranslation('STUDENT_IS_ACTIVE_STATUS'),
	        	                 // store:'Academia.store.student.report.StudentStatusStore',
	        	                  value:true
	        	              },
	        	        	  {
	        	        		  xtype: 'customcombobox',
	        	        		  name: 'programCategory',
	        	        		  ItemId : 'programCategory',
	        	        		  fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
	        	        		  store:'program.ProgramCategoryStore',
	        	        		  displayField:'value',
	        	        		  valueField:'id',
	        	        		  forceSelection:true,
	        	        		  matchFieldWidth:true
	        	        	  }]
	         }, {
	        	 xtype : 'fieldcontainer',
	        	 width : 'auto',
	        	 layout : 'hbox',
	        	 defaults : {
	        		 width : 226,
	        		 labelAlign : 'top'
	        	 },
	        	 items : [  {
	        		  xtype : 'customcombobox',
	        		  fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
	        		  name : 'programId',
	        		  allowBlank : false,
	        		  disabled:true,
	        		  itemId : 'programId',
	        		  store:'facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore',
	        		  displayField:'valueCode',
	        		  valueField:'id',
	        		  //width:460,
	        		  typeAhead:true,
	        		  matchFieldWidth:true,
	        		  forceSelection:true,
	        		//  triggerAction: 'all',
	        		  minChars:3,
	        		  queryParam:'searchText',
	        		  emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        		  listConfig: {
	        			  listeners: {
	        				  beforeshow: function(picker) {
	        					  picker.minWidth = picker.up('combobox').getSize().width;
	        				  }
	        			  },
	        			  loadingText: getCommonTranslation('SEARCHING'),
	        			  emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        			  getInnerTpl: function() {
	        				  return '<div class="search-item">' +
	        				  '{value}'  +
	        				  '</div>';
	        			  }
	        		  }
	        	  },
	        	          {
	        	        	  xtype: 'customcombobox',
	        	        	  name: 'batchId',
	        	        	  allowBlank : false,
	        	        	  itemId:'batchId',
	        	        	  fieldLabel: getProgramandcourseTranslation('BATCH'),
	        	        	  store:'enquiry.AcademicBatchStore',
	        	        	  valueField:'id',
	        	        	  displayField:'value',
	        	        	  disabled:true,
	        	        	  typeAhead:true,
	        	        	  forceSelection:true,
	        	        	  matchFieldWidth:true
	        	          }  ,   
	        	          {
	        	        	  xtype: 'customcombobox',
	        	        	  name: 'periodId',
	        	        	  itemId:'periodId',
	        	        	  allowBlank : false,
	        	        	  fieldLabel: getProgramandcourseTranslation('PERIOD'),
	        	        	  store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	        	        	  displayField:'value',
	        	        	  valueField:'id',
	        	        	  typeAhead:true,
	        	        	  disabled:true,
	        	        	  forceSelection:true,
	        	        	  matchFieldWidth:true
	        	          }]
	         }, {
	        	 xtype : 'fieldcontainer',
	        	 width : 'auto',
	        	 layout : 'hbox',
	        	 defaults : {
	        		 width : 226,
	        		 labelAlign : 'top'
	        	 },
	        	 items : [ 
       	          {
    	        	  xtype: 'numberfield',

    	        	  fieldLabel: getCommonTranslation('AGE'),
    	        	  minValue:1,

    	        	  itemId: 'age',
    	        	  name: 'age'
    	          },
	        	          {
	        	        	  xtype: 'customcombobox',
	        	        	  name: 'gender',
	        	        	  store: 'Academia.store.common.GenderTypeStore',
	        	        	  fieldLabel: getCommonTranslation('GENDER'),
	        	        	  editable: false,
	        	        	  valueField: 'id',
	        	        	  displayField: 'value'
	        	          }]
	         },


	         {
	        	 xtype : 'fieldcontainer',
	        	 width : 'auto',
	        	 items : [ {
	        		 xtype : 'button',
	        		 text : getCommonTranslation('SEARCH'),
	        		 itemId : 'searchBtn',
	        		 buttonAlign : 'left',
	        		 ui : 'CustomBtnSubmit',
	        		 scale : CONSTANTS.BUTTONSIZE,
	        		 disabled : true
	        		 //formBind : true
	        	 }, {
	        		 xtype : 'button',
	        		 text : getCourseTxCommonTranslation('RESET'),
	        		 itemId : 'resetBtn',
	        		 buttonAlign : 'left',
	        		 ui : 'CustomBtnCancel',
	        		 scale : CONSTANTS.BUTTONSIZE
	        	 } ]
	         } ]

});