/**
 * Priyanshi Sharma
 */
Ext.define('Academia.view.placement.placementcampus.PlacementCampusFollowUpGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.placementcampusfollowupgrid',
   store:'placement.placementcampus.PlacementCampusFollowupGridStore',
    title: getEnquiryTranslation('LIST_OF_FOLLOWUP_DETAILS'),
    border: true,
    refreshStoreData:true,
    id:'plcDriveFollowUpDetailGridId',
    autoScroll: false,
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS,
	loadMask: false
    },
    dockedItems : [ {
	xtype : 'toolbar',
	dock : 'bottom',
	items : [{
		xtype: 'custompagingtoolbar',
        plugins:['pagesize'],
        emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
	    store : 'placement.placementcampus.PlacementCampusFollowupGridStore',
	    displayInfo : true
	}]
    }],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar : [{
		xtype : 'button',				
		itemId : 'AddFollowUp',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
    },{
		xtype : 'button',				
		itemId : 'editFollowUp',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}],
    columns : [{
	    header :getPlacementTranslation('FOLLOW_UP_NAME'),
	    dataIndex : 'followupName',
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},{
	    header :getCommonTranslation('FOLLOW_UP_SCHEDULE'),
	    dataIndex : 'followUpDate',
	    flex:1,
	    renderer:function(date) {
			return dateRender(date);
		}
	}, {
	    header :getCommonTranslation('FOLLOW_UP_DATE'),
	    dataIndex : 'actualFollowUpDate',
	    flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
	    header : getCommonTranslation('FOLLOW-UP_ACTIVITY_TYPE'),
	    dataIndex : 'activityType',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},{
	    header : getCommonTranslation('REASON_FOR_FOLLOW-UP'),
	    dataIndex : 'reasonForFollowUp',
	    flex:1
	   /* renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }*/
	},{
	    header : getCommonTranslation('FOLLOW_UP_ACTIVITY_STATUS'),
	    dataIndex : 'followupStatus',
	    flex:1,
	   renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	}, {
	    header : getCommonTranslation('FOLLOW_UP_USER'),
	    dataIndex : 'followUpUser',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},{
	    header : getCommonTranslation('FOLLOW_UP_REMARK'),
	    dataIndex : 'remark',
	    flex:1
	},{
	    header : getCommonTranslation('STATUS'),
	    dataIndex : 'status',
	    hidden:true,
	    flex:1,
	    renderer:function(val, meta, record, rowIndex){
	    	return val;
	    }
	}]

});