/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.placement.placementcampus.PlacementDriveGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementdrivegrid',
	store: 'placement.placementcampus.PlacementCampusGridStore',
	title: getCommonTranslation('PLACEMENT_CAMPUS_LIST'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementcampus.PlacementCampusGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('PLACEMENT_CAMPUS_NAME'),
		dataIndex: 'campusName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PLACEMENT_TYPE'),
		dataIndex: 'placementType',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_COORDINATOR'),
		dataIndex: 'campusCoordinator',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}
	},{
		header:  getCommonTranslation('PLACEMENT_START_DATE'),
		dataIndex: 'startDate',
		flex:.1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('PLACEMENT_END_DATE'),
		dataIndex: 'endDate',
		flex:.1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header:  getPlacementTranslation('COMPANY'),
		dataIndex: 'recruitingOrganizationCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.recruitingOrganizationCount == 0){
					return "";
				} else {
					return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:  getCommonTranslation('PLACEMENT_ORGANIZING_ACADEMY_LOCATION'),
		dataIndex: 'organizingAcademyLocation',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_MOD'),
		dataIndex: 'placementMOD',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.itemValue;
			else 
				return null;
		}
	}]
});

