/**
 * @author Deepak Nigam
 */
Ext.define('Academia.view.placement.placementjob.PlacementAvailableJobGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementavailablejobgrid',
	store: 'placement.placementjobapplication.PlacementAvailableJobApplicationGridStore',
	title:  getPlacementTranslation('PLACEMENT_LIST_OF_AVAILABLE_JOBS'),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementjobapplication.PlacementAvailableJobApplicationGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		text: getPlacementTranslation('APPLY'),
		itemId: 'applyJobId'
	}],
	columns: [{
		header:  getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE'),
		dataIndex: 'jobTitle',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PATH_PLACEMENT_CAMPUS'),
		dataIndex: 'placementCampusName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('COMPANY'),
		dataIndex: 'companyName',
		flex:.1
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_COORDINATOR'),
		dataIndex: 'coordinator',
		flex:.1
	},{
		header:  getCommonTranslation('LOCATIONSTABTEXT'),
		dataIndex: 'noOfLocations',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value) && value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "";
			}
		}
	},/*{
		header:  getPlacementTranslation('JOB_LOCATIONS'),
		dataIndex: 'jobLocation',
		flex:.1,
		sortable:true
	},*/{
		header:  getPlacementTranslation('PLACEMENT_SELECTION_PROCESS'),
		dataIndex: 'selectionStage',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}else{
				return null;
			}
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_DESCRIPTION'),
		dataIndex: 'jobDescription',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return '<a href="#">View</a>';
			}else{
				return null;
			}
		}
	},{
		header:  getCommonTranslation('DOCUMENT'),
		dataIndex: 'documentName',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return '<a href="#">View</a>';
			}else{
				return null;
			}
		}
	},{
        header: getPlacementTranslation('JOB_DESCRIPTION_DOCUMENT'),
        dataIndex: 'jobPostingDocuments',
        flex: .1,
        //hidden: true,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length > 0) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }]
});
