/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.placement.placementjob.PlacementJobForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.placementjobform',
	autoScroll: true,
	bodyPadding:'10 10 10 10',
	frame:true,
	itemId:'placementjobformItemId',
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	title:getPlacementTranslation('PLACEMENT_JOB_DETAILS'),
	method: 'POST',
	defaults: {
		labelAlign: 'top',
		width: 226
	},
	plugins : "formlabelrequired",
	items : [{
		xtype: 'hidden',
		name: 'id'
		},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'jobTitle',
			itemId:'placementJobItemId',
			fieldLabel : getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE'),
			allowBlank:false
		},{
			xtype: 'customcombobox',
			name: 'placementCampus',
			itemId:'placementcampusItemId',
			store:'placement.placementcampus.PlacementCampusStore',
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CODE_CAMPUS'),
    	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
    	    displayField:'valueCode',
			valueField:'id',
			editable: true,	    
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'academyLocation',
			itemId:'academyLocation',
			store:'placement.placementcampus.PlacementCampusProgramPeriodALStore',
			allowBlank:false,
			fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
    		name:'coordinator',
    		itemId:'campusCoordinator',
    		store: 'placement.placementcampus.placementCampusCoordinatorStore',
    		fieldLabel : getPlacementTranslation('PLACEMENT_CAMPUS_COORDINATOR'),
    		valueField: 'id',
    		displayField: 'valueCode',
    		queryParam:'name',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		}]
		
	},{
		
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
    		itemId: 'selectionStageCombo',
    		name:'selectionStageCombo',
            store: 'admission.admissionCycle.SelectionProcessesStore',
    		fieldLabel: getPlacementTranslation('PLACEMENT_SELECTION_PROCESS'),
            displayField: 'value',
            valueField: 'id',
//            queryMode: 'local',
            width: 226,
            labelAlign: 'top',
            autoload: false,
            allowBlank: false
		},{
			xtype:'panel',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				labelAlign: 'top',
				itemId:'onSelectStage',
				disabled:true,
				fieldLabel: getPlacementTranslation('PLACEMENT_SELECTION_MODE'),
				columns: 2,
				allowBlank: false,
				vertical: true,
				items: [{ boxLabel: getCommonTranslation('BATCHES'), name: 'selectRadio', inputValue: true,checked:true},
				        { boxLabel: getPlacementTranslation('INDIVIDUAL'), name: 'selectRadio', inputValue: false}
				]
			}]			
			
		}]
		
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
    		itemId: 'eligibilityRule',
    		name:'eligibilityRule',
            store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
    		fieldLabel: getPlacementTranslation('ELIGIBILITY_RULE'),
            displayField: 'value',
            valueField: 'id',
            width: 226,
            labelAlign: 'top',
            autoload: false,
            allowBlank: true
		},{
			xtype: 'datefield',
			name: 'dateFrom',
			itemId:'startDate',
			allowBlank:false,
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
    		vtype: 'daterange',
			endDateField: 'endDate',
			editable:false,
			fieldLabel:getPlacementTranslation('RECRUITMENT_DATE_FROM')
		},{
			xtype: 'datefield',
			name: 'dateTo',
			itemId:'endDate',
			allowBlank:true,
			vtype: 'daterange',
			startDateField: 'startDate',
			editable:false,
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
    		listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
			fieldLabel:getPlacementTranslation('RECRUITMENT_DATE_TO')
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'textarea',
			name:'description',
			itemId:'remarks',
			width: 460,
			maxLength : 1000,
			fieldLabel: getPlacementTranslation('PLACEMENT_JOB_DESCRIPTION')
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'vbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype:'jobpostingdocumentgrid',
			itemId : 'jobPostingDocumentGridItemId',
			style:{
				marginLeft:'0px'
			}
		},{
			xtype: 'button',
			text:getCommonTranslation('UPLOAD_DOC'),
			itemId: 'jobPostingDocumentUploadId',
			ui: 'CustomBtnThird',
			scale : CONSTANTS.BUTTONSIZE
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE') ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		//itemId: 'programFormCancelButtonId',
    		itemId: 'resetBtn',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
