Ext.define('Academia.view.program.ProgramBatchPeriodWindow', {
	extend: 'Ext.window.Window',
	alias : 'widget.programbatchperiodwindow',
	border: true,
	modal : true,
	title: getCommonTranslation('PROGRAM_DETAILS'),
	autoScroll: true,
	maxHeight: 400,
	height:400,
	width: '50%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	items:[{
		xtype: 'form',
		plugins:"formlabelrequired",
		items: [{
			xtype: 'grid',
			itemId:'programbatchperiodId',
			border:true,
			autoScroll: false,
			viewConfig: {
				stripeRows: CONSTANTS.STRIPEROWS
			},
			store :'program.ProgramBatchPeriodStore',
			dockedItems: [{
		    	xtype : 'toolbar',
		    	dock : 'bottom',
		    	items : [ {
		    	    xtype : 'custompagingtoolbar',
		    	    plugins:['pagesize'],
		    	    store : 'program.ProgramBatchPeriodStore',
		    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
		    	    displayInfo : true
		    	} ]
		}],
			columns : [{
				header :getCommonTranslation('PROGRAM_NAME'),
				dataIndex : 'programName',
				flex : 1,
				sortable : true
			}, {
				header : getCommonTranslation('BATCH_NAME'),
				dataIndex : 'batchName',
				flex : 1,
				sortable : true
			},{
				header : getCommonTranslation('PERIOD_NAME'),
				dataIndex : 'periodName',
				flex : 1,
				sortable : true
			}]
			
		}]
	}]
});