/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.courseFeeDefinition.ManageFeeHeadConfigurationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.managefeeheadconfigurationgrid',
	title: getCommonTranslation('SUBHEAD_CONFIGURATION'),
	store: Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridStore'),
	border: true,

	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,

	},
	/*	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridStore'),
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],*/
	/*initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},*/
	tbar: [	{  
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
		},{   
			xtype: 'button',
			text: getCommonTranslation('SUBMIT'),
			itemId: 'submitBtn',
			scale: CONSTANTS.BUTTONSIZE,
			formBind :true,
			hidden:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE,
			hidden:true

		}],
		columns: [{
			header:  getCommonTranslation('SERIAL_NO'),
			dataIndex: 'serialNo',
			flex:.1,
			sortable: false,

		},{
			header:  getCommonTranslation('SUB_HEAD'),
			dataIndex: 'feeHead',
			flex:.1,
			sortable: false,
			editor:{
				xtype: 'customcombobox',
				itemId: 'subheadItemId',
				name: 'subHeadName', 
				store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationSubHeadStore'),
				valueField:'id',
				displayField:'value',
				typeAhead:false,
				forceSelection:true,
				queryParam:'qry',
				id: 'resume-applicantdetails-view-address',

			},
			listeners: {
				render: function(combo){
					if(!isNullOrEmpty(combo)){
						combo.getEditor().store.load();
					}
				}
			},
			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				if(!isNullOrEmpty(value) && value !== '') {
					try{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
							return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
						}else{
							rec.tdCls = 'gridInputCustomStyle';
							return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
					catch(e){
						return null;
					}
				}
				else {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		},{
			header:  getCommonTranslation('AMOUNT/WEIGHTAGE'),
			dataIndex: 'amountOrWeightage',
			flex:.1,
			sortable: false,
			editor:{
				xtype: 'numberfield',
				itemId: 'amountOrWeightage',
				name: 'amountOrWeightage',
				maxValue: 100,
				minValue:0,
				listeners: {

					focus: function(combo, e, eOpts) {
						var grid = combo.up('grid');
						var structure = grid.up();
						var filter = structure.down('managefeeheadconfigurationfilter');
						var feeTypeValue = filter.down('#feeheadTypeId').getValue();
						if(feeTypeValue =="FIXED" || feeTypeValue =="Fixed"){
							combo.setMaxValue(9999999999);
							combo.setMinValue(0);
						}
						else if(feeTypeValue =="CREDIT_BASED" || feeTypeValue =="Credit Based"){
							combo.setMaxValue(100);
							combo.setMinValue(1);
						}
					},

				}
			},
			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				if(!isNullOrEmpty(value) && value !== '') {
					try{
						return value;
					}
					catch(e){
						return null;
					}
				}
				else {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		},{
			header:  getCommonTranslation('COST_CENTER'),
			dataIndex: 'costCentre',
			flex:.1,
			sortable: false, 
			editor:{
				xtype: 'customcombobox',
				itemId: 'costCentre',
				name: 'costCentre', 
				store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationCostCenterStore'),
				valueField:'id',
				displayField:'value',
				typeAhead:false,
				forceSelection:true,
				queryParam:'qry',
				listeners: {

					focus: function(combo, e, eOpts) {
						combo.getStore().load();
					},
					select: function(view,record){
						return record[0].data.value;
					}

				}
			},
			listeners: {
				render: function(combo){
					if(!isNullOrEmpty(combo)){
						combo.getEditor().store.load();
					}
				}
			},
			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				if(!isNullOrEmpty(value) && value !== '') {
					try{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
							return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
						}else{
							rec.tdCls = 'gridInputCustomStyle';
							return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
					catch(e){
						return null;
					}
				}
				else {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		},{
			header:  getCommonTranslation('REFUNDABLE'),
			dataIndex: 'isRefundable',
			flex:.1,
			sortable: false,
			editor:{
				xtype: 'customcombobox',
				itemId: 'isRefundable',
				name: 'isRefundable', 
				store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationRefundableRuleStore'),
				valueField:'id',
				displayField:'value',
				typeAhead:false,
				forceSelection:true,
				queryParam:'qry',
				listeners: {

					focus: function(combo, e, eOpts) {
					},
					change : function(obj, newValue) {
					    var grid = obj.up('grid');
					    if(newValue==false)
					{
					var rec = grid.getSelectionModel().getSelection()[0];
					rec.set('rule','')
					grid.columns[5].getEditor().disable(true);
					}
					else
					{
					grid.columns[5].getEditor().enable(true);
					}
					},

				}
			},
			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				if(!isNullOrEmpty(value) && value !== '') {
					try{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
							return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
						}else{
							rec.tdCls = 'gridInputCustomStyle';
							return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
					catch(e){
						return null;
					}
				}
				else {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}

		},{
			header:  getCommonTranslation('REFUND_RULE'),
			dataIndex: 'rule',
			flex:.1,
			sortable: false,
			editor:{
				xtype: 'customcombobox',
				itemId: 'refundRule',
				name: 'refundRule', 
				store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationRuleStore'),
				valueField:'id',
				displayField:'value',
				typeAhead:false,
				forceSelection:true,
				listeners: {

					focus: function(combo, e, eOpts) {
						combo.getStore().getProxy().extraParams={
							moduleName:"FEE"
						}
						combo.getStore().load();
					},
					

				}
			},
			listeners: {
				render: function(combo){
					if(!isNullOrEmpty(combo)){
						combo.getEditor().getStore().getProxy().extraParams={
							moduleName:"FEE"
						}
						combo.getEditor().getStore().load();
					}
				}
			},
			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				if(!isNullOrEmpty(value) && value !== '') {
					try{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
							return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
						}else{
							rec.tdCls = 'gridInputCustomStyle';
							return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
					catch(e){
						return null;
					}
				}
				else if(value == '' && isNullOrEmpty(value) && record.data.isRefundable == false){
					rec.column.getEditor().disable(true);
					
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}

		},
		{
			header:  getCommonTranslation('DISCOUNT_RULE'),
			dataIndex: 'discountRule',
			flex:.1,
			sortable: false, 
			editor:{
				xtype: 'customcombobox',
				itemId: 'discountRule',
				name: 'discountRule', 
				store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationDiscountRuleStore'),
				valueField:'id',
				displayField:'value',
				typeAhead:false,
				forceSelection:true,
				
				listeners: {

					focus: function(combo, e, eOpts) {
						combo.getStore().getProxy().extraParams={
							moduleName:"FEE"
						}
						combo.getStore().load();
					},

				}
			},
			listeners: {
				render: function(combo){
					if(!isNullOrEmpty(combo)){
						combo.getEditor().store.load();
					}
				}
			},
			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				if(!isNullOrEmpty(value) && value !== '') {
					try{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
							return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
						}else{
							rec.tdCls = 'gridInputCustomStyle';
							return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
					catch(e){
						return null;
					}
				}
				else {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		},
		{
			header: getCommonTranslation('ADD'),
			dataIndex: 'addButton',
			flex:.1,
			cls: 'CustomBodyBtnSettings',
			style:{'text-align':'center'},
			sortable: false,
			renderer: function(value, meta, record) {
				if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.manageCourseOutComeId))
					return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
				return '';
			}
		}, {
			header: getServiceRequestTranslation('EMM_DELETE'),
			dataIndex: 'deleteButton',
			flex:.1,

			cls: 'CustomBodyBtnSettings',
			style:{'text-align':'center'},
			sortable: false,
			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.manageCourseOutComeId)) {
					return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
				}	
				return '';
			}
		}],
		plugins: {
			ptype: 'cellediting',
			clicksToEdit: 1,

		},
		listeners: {
			beforeedit: function(editor, context) {
				
				if(editor.context.field == 'rule'){
					if(context.record.data.isRefundable == false ){
						context.grid.columns[5].getEditor().setReadOnly(true);
						
					}else{
						context.grid.columns[5].getEditor().setReadOnly(false);
						context.grid.columns[5].getEditor().enable(true);
						
					}
				}
				
			}
		}
});
