/**
 * @ Ravi Choudhary
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.periods.ProgramPeriodForm', {
//	extend: 'Ext.window.Window',
//	extend: 'Ext.form.FormPanel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.programperiodformwindow',
	customFieldEntity:CONSTANTS.PROGRAM_BATCH_PERIOD_CD,
	columns: 2,
	frame:true,
	id:'programPeriodsFormWindow_Id',
//	modal: true,
	title: getCommonTranslation('PERIOD_DETAILS'),
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	height:500,
	autoScroll: true,
	layout: {
		type: 'vbox'
	},
	standardSubmit: false,
	defaults: {
		labelAlign: 'top'
	},
	plugins:"formlabelrequired",
	items: [{
		xtype : 'hidden',
		name : 'id'
	},{
		xtype : 'hidden',
		name : 'version'
	},{
		xtype : 'hidden',
		name : 'minCreditsPeriod'
	},{
		xtype : 'hidden',
		name : 'minCoursesPeriod'
	},{
		xtype : 'hidden',
		name : 'maxCreditsPeriod'
	},{
		xtype : 'hidden',
		name : 'maxCoursesPeriod'
	},{
		xtype:'fieldset',
		title: getCommonTranslation('BASIC_DETAILS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:false,
		width:'100%',
		itemId : 'periodBasicDetailsItemId',
		items: [{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items: [{
					xtype:'textfield',
					name:'programPeriodSeq',
					fieldLabel:getCommonTranslation('PROGRAM_SEQUENCE'),
//					translationKey: 'PROGRAM_SEQUENCE',
					readOnly:true
				},{
					xtype:'textfield',
					name:'programPeriodName',
					itemId:'periodName_id',
					fieldLabel:getCommonTranslation('PROGRAM_PERIOD_NAME') ,
//					translationKey: 'PROGRAM_PERIOD_NAME',
					allowBlank: false
				},{
					xtype: 'textfield',
					name: 'printName',
					itemId:'printNameItemId',
					fieldLabel: getCourseTxCommonTranslation('PRINT_NAME')
				}]
		      },{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: [{
						xtype: 'textfield',
						name: 'printNameInFrench',
						itemId:'printNameInFrenchItemId',
						fieldLabel: getCommonTranslation('PRINT_NAME_IN_FRENCH'),
						hidden:true,
						maxLength: 255
					},{
						xtype: 'textfield',
						name: 'printNameInSpanish',
						itemId:'printNameInSpanishItemId',
						fieldLabel: getCommonTranslation('PRINT_NAME_IN_SPANISH'),
						hidden:true,
						maxLength: 255
					}]
			      },{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: [{
						xtype:'textfield',
						name:'attestationLineOne',
						itemId:'attestationLineOne',
						fieldLabel:getCommonTranslation('ATTESTATION_LINE_ONE'),
						hidden:true,
						maxLength: 50
					},{
						xtype:'textfield',
						name:'attestationLineTwo',
						itemId:'attestationLineTwo',
						fieldLabel:getCommonTranslation('ATTESTATION_LINE_TWO') ,
						hidden:true,
						maxLength: 50
					}]
			      },{
				xtype: 'fieldcontainer',
				width: '100%',
				layout: {
					type: 'hbox'
				},
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					name: 'academicTerm',
					itemId: 'academicTerm',
					fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
					store : Ext.create('Academia.store.common.AcademicTermStore'),
					valueField: 'id',
					displayField: 'value',
					queryMode:'local',
					typeAhead: true,
					forceSelection: true,
					allowBlank: false,
					anyMatch : true
				},{
					xtype : 'datefield',
					anchor : '100%',
					id:'periodStart',
					fieldLabel : getCommonTranslation('PROGRAM_PERIOD_START'),
//					translationKey: 'PROGRAM_PERIOD_START',
					name : 'programPeriodStart',
					itemId:'programPeriodStart',
					endDateField : 'programPeriodEnd',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat : CONSTANTS.DATE_FORMAT,
					vtype : 'daterange',
					allowBlank:false
				},{
					xtype : 'datefield',
					anchor : '100%',
					id:'periodEnd',
					fieldLabel : getCommonTranslation('PROGRAM_PERIOD_END'),
//					translationKey: 'PROGRAM_PERIOD_END',
					name : 'programPeriodEnd',
					itemId : 'programPeriodEnd',
					startDateField : 'programPeriodStart',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat : CONSTANTS.DATE_FORMAT,
					vtype : 'daterange',
					allowBlank:false
				}]
			},{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items: [{
					xtype : 'customcombobox',
					name : 'periodYear',
					itemId : 'periodYear',
					fieldLabel : getCommonTranslation('PERIOD_YEAR'),
					store:Ext.create('Academia.store.program.PeriodYearStore'),
					valueField : 'id',
					displayField : 'value',
					allowBlank : true,
					editable:false,
					forceSelection:true,
					typeAhead:false
				},{
					xtype: 'radiogroup',
					name:'whetherPlacementPeriod_ID',
					fieldLabel: getCommonTranslation('PLACEMENT_PERIODS'),
					itemId:'whetherPlacementPeriod_ID',
					items:[{ boxLabel: 'Yes', name:'whetherPlacementPeriod', inputValue: true },
						{ boxLabel: 'No', name:'whetherPlacementPeriod', inputValue: false}
					]
				},{
					xtype: 'radiogroup',
					fieldLabel: getCommonTranslation('CONSIDER_ONLY_PROMOTIONAL_COURSE'),
					itemId: 'considerOnlyPromotionalCoursesId',
					height:75,
					name: 'considerOnlyPromotionalCoursesId',
					allowBlank: true,
					items:[{ 
						boxLabel: getCommonTranslation('YES'),
						name:'considerOnlyPromotionalCourses',
						inputValue: true 
					},{ 
						boxLabel: getCommonTranslation('NO'), 
						name:'considerOnlyPromotionalCourses',
						inputValue: false,
						checked:true
					}]
				}]
			},{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items: [{
					xtype: 'radiogroup',
					fieldLabel: getCommonTranslation('IS_LAST_PERIOD'),
					height:90,
					itemId: 'isLastPeriodOfProgram',
					name: 'isLastPeriodOfProgram',
					allowBlank: false,
					items:[{ 
						boxLabel: getCommonTranslation('YES'),
						name:'isLastPeriodOfProgram',
						inputValue: true 
					},{ 
						boxLabel: getCommonTranslation('NO'), 
						name:'isLastPeriodOfProgram',
						inputValue: false,
						checked:true
					}]
				},{
					xtype: 'radiogroup',
					fieldLabel: getCourseTxCommonTranslation('IS_OPTIONAL_PERIOD'),
					itemId: 'whetherOptionalPeriodId',
					name: 'whetherOptionalPeriodId',
					allowBlank: false,
//					disabled:true,
					items:[{ 
						boxLabel: getCommonTranslation('YES'),
						name:'whetherOptionalPeriod',
						inputValue: true 
					},{ 
						boxLabel: getCommonTranslation('NO'), 
						name:'whetherOptionalPeriod',
						inputValue: false,
						checked:true
					}]
				},{
					xtype: 'customcombobox',
					name:'succeedingPeriodId',
					itemId:'succeedingPeriodId',
					store: Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgramBatchSucceedingPeriodStore'),
					fieldLabel: getCourseTxCommonTranslation('SUCCEDING_PERIOD'),
					valueField: 'id',
					displayField: 'value',
					forceSelection:true,
					enableKeyEvents  : 'true',
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING')
					}
				}]
			},{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items: [{
					xtype:'customcombobox',
					name:'programPeriodRankBasis',
					itemId:'programPeriodRankBasis',
					fieldLabel: getCommonTranslation('PROGRAM_PERIOD_RANK_BASIS'),
//					translationKey: 'PROGRAM_PERIOD_RANK_BASIS',
					store:'program.programDetails.programBatches.programPeriod.ProgramPeriodRankBasisStore',
					valueField:'id',
					displayField:'value',
					allowBlank:false
				},{
					xtype: 'customcombobox',
					name:'equivalentPeriod',
					itemId:'equivalentPeriod',
					store: 'placement.EquvalentPeriodStore',
					fieldLabel: getCommonTranslation('EQUIVALENT_PERIOD'),
					valueField: 'id',
					displayField: 'value',
					forceSelection:true,
					enableKeyEvents  : 'true',
					disabled:true,
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING')
					}
				},{
					xtype: 'customcombobox',
					name:'placementType',
					itemId:'placementType',
					store: 'placement.PlacementTypeStore',
					fieldLabel: getCommonTranslation('PLACEMENT_TYPE'),
					valueField: 'id',
					displayField: 'value',
					forceSelection:true,
					disabled:true,
					enableKeyEvents  : 'true',
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING')
					}
				}]
			},{
					xtype: 'fieldcontainer',
					width:'100%',
					
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						height: 58,
						labelAlign:'top'
					},
					items:[{
						xtype: 'radiogroup',
						fieldLabel: getProgramandcourseTranslation('SPECIALIZATION_REQUIRED'),
						itemId: 'specializationReq',
//						name: 'specializationReq',
						allowBlank: false,
						items:[{ 
							boxLabel: getCommonTranslation('YES'),
							name:'specializationReq',
							inputValue: true 
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name:'specializationReq',
							inputValue: false,
							checked:true
						}]
					},{
						xtype: 'customcombobox',
						name: 'campus',
						itemId:'campusId',
						fieldLabel: getProgramandcourseTranslation('CAMPUS'),
						store:Ext.create('Academia.store.program.ProgramCampusStore'),
						valueField: 'id',
						displayField: 'value',
						maxLength:15000,
						autoloadStore: false,
		    			queryMode:'local',
		    			height: 'auto',
					//	cls:'commonAutoHeightMultiselectField',
		    			listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING')
						}		            	
					},{
						xtype: 'multiselectcombofield',
						name: 'periodStatus',
						itemId:'periodStatusId',
						fieldLabel: getProgramandcourseTranslation('PERIOD_STATUS'),
						valueField: 'id',
						displayField: 'value',
						maxLength:15000,
						autoloadStore: false,
		    			queryMode:'local',
		    			typeAhead : true,
						forceSelection : true,
						allowBlank:false,
						anyMatch : true,
						cls:'commonAutoHeightMultiselectField',
						listConfig: {
		    				listeners: {
		    					beforeshow: function(picker) {
		    						picker.width = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    				getInnerTpl: function() {
		    					return '<div class="search-item">' +
		    					'{value}' +
		    					'</div>';
		    				}
		    			},
		            	listeners  :{
		            		render : function(combo){
		            			var store=Ext.create('Academia.store.program.ProgramPeriodStatusStore');
		            			combo.bindStore(store);
		            			store.load();
		            		}
		            	}
					}]
					},{
						xtype: 'fieldcontainer',
						width:'100%',
						layout: {
							type: 'hbox'
						},
						defaults :{
							width: 226,
							labelAlign:'top'
						},
						items: [{
							xtype:'customcombobox',
							style:{
								marginLeft:10
							},
							name:'offeredAtAL',
							itemId:'offeredAtAL',
							fieldLabel: getCommonTranslation('OFFERED_AT_AL'),
							store:Ext.create('Academia.store.campaign.pAdmCompaignALMappingStore'),
							valueField:'id',
							displayField:'value',
							queryMode:'local',
							typeAhead: true,
							forceSelection: true,
							allowBlank: false,
							anyMatch : true
						},{
					        xtype: 'customcombobox',
					        name:'administrator',
					        store: 'common.AllUserBySmartSearch',
					        fieldLabel: getProgramandcourseTranslation('ADMINISTRATOR'),
					        valueField: 'id',
					        displayField: 'value',
					        queryParam:'codeOrName',
					        minChars:3,
					        allowBlank: true,
					        typeAhead:false,
		                    triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		                    enableKeyEvents  : 'true',
		                    hideTrigger:false,
		                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                    triggerAction: '',
		                    forceSelection:true,
					        listConfig: {
						    listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                        '{value}' +
			                    '</div>';
			                }
			            }
				},{
							xtype: 'customcombobox',
				            name: 'computerUserArea',
				            itemId:'computerUserArea',
				            fieldLabel: getCommonTranslation('COMPUTER_USER_AREA'),
				            store: Ext.create('Academia.store.common.ComputerUserAreaStore'),
				            displayField:'value',
				            valueField:'id',
				            hidden:true,
				            forceSelection:true,
				            editable: false,
				            matchFieldWidth:true,
				            listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.width = picker.up('combobox').getSize().width;
									}
								}
				            }} ]
					}]
	},{
		xtype:'fieldset',
		title: getCommonTranslation('ENROLLMENT_DETAILS_AND_DEADLINES'),
		frame:true,	
		collapsible:true,
		collapsed:false,
		width:'100%',
		margin: '-10 0 0 0',
		itemId : 'periodEnrollmentDetailsAndDeadlinesItemId',
		items: [{
			xtype : 'fieldcontainer',
			width : '100%',
			minHeight: 110,
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'radiogroup',
				fieldLabel: getProgramandcourseTranslation('REGISTRATION_PROCESS_REQUIRED'),
				itemId: 'registrationProcessReq',
//				name: 'registrationProcessReq',
				allowBlank: false,
				items:[{ 
					boxLabel: getCommonTranslation('YES'),
					name:'registrationProcessReq',
					inputValue: true 
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name:'registrationProcessReq',
					inputValue: false,
					checked:true
				}]
			},{
				xtype : 'customcombobox',
				name : 'registrationTermSetupDetail',
				itemId : 'registrationTermSetupDetail',
				store : Ext.create('Academia.store.registrationTermSetupDetail.registrationTermSetupDetailStore'),
				//store : 'registrationTermSetupDetail.registrationTermSetupDetailStore',
				fieldLabel : getProgramandcourseTranslation('REGISTRATION_SETUP_NAME'),
				valueField : 'id',
				displayField : 'value',
				hidden:true,	
				allowBlank : false,
				editable:false,
				forceSelection:true,
				typeAhead:false,
				style:{
					marginBottom:'30px'
				}
			},{
				xtype : 'datefield',
				anchor : '100%',
				//margin: '15 0 5 0',
				allowBlank:false,
				fieldLabel : getCommonTranslation('SET_DEADLINE_ENROLLMENT'),
				name : 'enrollmentLastDate',
				itemId : 'enrollmentLastDateItemId',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange',
				style:{
					marginBottom:'30px'
				}
			},{
				xtype: 'checkboxfield',
				labelAlign: 'right',
				style:{
					marginLeft:'8px',
					marginTop:'25px'
				},
				boxLabel: getProgramandcourseTranslation('ENROLLED_DIRECTLY'),
				name: 'enrolledDirectly',
				itemId:'enrolledDirectly',
				inputValue: true,
				hidden:true,
				checked:true
			}]
		},{
			xtype : 'fieldcontainer',
			itemId:'enrollmentSettingContId',
			width : '100%',
			//margin: '-35 0 0 0',
			layout : {
				type : 'vbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'fieldcontainer',
				width : '100%',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype:'numberfield',
					name:'minCourses',
					itemId:'minCourses_Id',
					fieldLabel: getCommonTranslation('MINIMUM_COURSES'),
					minValue : 0,
					value:1,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:false,
					allowBlank:false,
					/*validator : function(val) {
						var maxValuefield = Ext.ComponentQuery.query('numberfield#maxCourses_Id')[0];
						var maxValue = maxValuefield.getValue();
						if (maxValue != null) {
							if (val <= maxValue) {
								maxValuefield.clearInvalid();
								return true;
							} else {
								return 'Less than maximum courses';
							}
						} else {
							return true;
						}
					}*/
				},{
					xtype:'numberfield',
					itemId:'maxCourses_Id',
					name:'maxCourses',
					fieldLabel: getCommonTranslation('MAXIMUM_COURSES'),
					minValue : 0,
					value:1,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:false,
					allowBlank:false,
					validator : function(val) {
						var minValueField = Ext.ComponentQuery.query('numberfield#minCourses_Id')[0];
						var minValue = minValueField.getValue();
						if (minValue != null) {
							if (val >= minValue) {
								minValueField.clearInvalid();
//								minValueField.up('form').getForm().isValid();
								return true;
							} else {
								return 'More than minimum courses';
							}

						} else {
							return true;
						}
					}
				}]
			},{
				xtype:'displayfield',
				name:'minimumCourseMsg',
				width:'auto',
				hidden:true	
			},{
				xtype:'displayfield',
				name:'maximumCourseMsg',
				width:'auto',
				hidden:true	
			},{
				xtype : 'fieldcontainer',
				width : '100%',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype:'numberfield',
					itemId:'minCredits_Id',
					name:'minCredits',
					fieldLabel: getCommonTranslation('MINIMUM_CREDITS'),
					minValue : 0,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:true,
					decimalPrecision: 2,
					allowBlank:false,
					validator : function(val) {
						var maxValuefield = Ext.ComponentQuery
						.query('numberfield#maxCredit_Id')[0];
						var maxValue = maxValuefield
						.getValue();
						if (maxValue != null) {
							if (val <= maxValue) {
								maxValuefield
								.clearInvalid();
								return true;
							} else {
								return 'Less than maximum credits';
							}
						} else {
							return true;
						}
					}
				},{
					xtype:'numberfield',
					itemId:'maxCredit_Id',
					name:'maxCredit',
					fieldLabel: getCommonTranslation('MAXIMUM_CREDITS'),
					minValue : 0,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:true,
					decimalPrecision: 2,
					allowBlank:false,
					validator : function(val) {
						var minValueField = Ext.ComponentQuery
						.query('numberfield#minCredits_Id')[0];
						var minValue = minValueField
						.getValue();
						if (minValue != null) {
							if (val >= minValue) {
								minValueField
								.clearInvalid();
								return true;
							} else {
								return 'More than minimum credits';
							}

						} else {
							return true;
						}
					}
				}]
			}]
		},{
			xtype:'displayfield',
			name:'minimumCreditMsg',
			width:'auto',
			hidden:true	
		},{
			xtype:'displayfield',
			name:'maximumCreditMsg',
			width:'auto',
			hidden:true	
		},
		{
			xtype:'displayfield',
			name:'customFieldHolder',
			width:'auto',
			hidden:true	
		},{
			xtype:'displayfield',
			name:'customFieldHolder2',
			width:'auto',
			margin: '0 0 -60 0',
			hidden:true	
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			//height : 85,
			margin: '10 0 -35 0',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'fieldcontainer',
				width : '100%',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width : 226,
					labelAlign : 'top'
			},
			items : [{
			xtype: 'fieldset',
			width: 226,
			cls: 'customTwoFieldContainerCls',
			itemId : 'studentCourseSelectionStartDateTimeLabelId',
			title: getCommonTranslation('START_DATETIME_FOR_COURSE_SELECTION_BY_STUDENT'),
			layout: 'hbox',
			items: [{
				xtype : 'datefield',
				width: 115,
				anchor : '100%',
				margin: '15 0 0 0',
				name : 'studentCourseSelectionStartDate',
				itemId : 'studentCourseSelectionStartDate',
				endDateField : 'studentCourseSelectionEndDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				disabled:false,
				vtype : 'daterange'
			
			},{
				xtype:'tbspacer',
				width:10
			},{
				xtype : 'timefield',
				width: 100,
				margin: '13 0 5 0',
				name : 'studentCourseSelectionStartTime',
				itemId : 'studentCourseSelectionStartTime',
				startDateField : 'startDate',
				disabled : false,
				submitFormat : CONSTANTS.DISPLAY_TIME_FORMAT,
				listeners :{
					render : function(field) {
						return timeFormatRender(field);
					}
				}
			}]
		}, {
			xtype: 'fieldset',
			width: 226,
			cls: 'customTwoFieldContainerCls',
			itemId : 'studentCourseSelectionEndDateTimeLabelId',
			title: getCommonTranslation('END_DATETIME_FOR_COURSE_SELECTION_BY_STUDENT'),
			layout: 'hbox',
			style: 'margin-left:10px !important;',
			items: [{
				xtype : 'datefield',
				width: 115,
				margin: '15 0 0 0',
				anchor : '100%',
				name : 'studentCourseSelectionEndDate',
				itemId : 'studentCourseSelectionEndDate',
				starttDateField : 'studentCourseSelectionStartDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				disabled:false,
				vtype : 'daterange'
			
			},{
				xtype:'tbspacer',
				width:10
			},{
				xtype : 'timefield',
				width: 100,
				margin: '13 0 0 0',
				name : 'studentCourseSelectionEndTime',
				itemId : 'studentCourseSelectionEndTime',
				startDateField : 'startDate',
				disabled : false,
				submitFormat : CONSTANTS.DISPLAY_TIME_FORMAT,
				listeners : {
					render : function(field) {
						return timeFormatRender(field);
					}
				}
			}]
		}]
		}]
		},{
		xtype : 'fieldcontainer',
		width : '100%',
		itemId:'setDeadLineContId',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getCommonTranslation('KYS_START_DATE'),
				name : 'kysStartDate',
				itemId : 'kysStartDate',
				startDateField : 'startDate',
				disabled:true,
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				//vtype : 'daterange',
				listeners:{
					render: function(field) {
						return dateFormatRender(field);
					},
					change:function(obj, newValue, oldValue, eOpts){
						obj.nextSibling().setMinValue(newValue);
					}
				}
			}, {
				xtype : 'datefield',
				fieldLabel : getCommonTranslation('KYS_END_DATE'),
				name : 'kysEndDate',
				itemId : 'kysEndDate',
				startDateField : 'startDate',
				disabled:true,
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				// vtype : 'daterange',
				listeners:{
					render: function(field) {
						return dateFormatRender(field);
					},
					change:function(obj, newValue, oldValue, eOpts){
						obj.previousSibling().setMaxValue(newValue); 
					}
				}
			}]
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		itemId:'setDeadLineContId1',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getCommonTranslation('EXAM_CANCELLATION_APPLICABLE_FROM_DATE'),
				name : 'examCancellationApplicableFromDate',
				itemId : 'examCancellationApplicableFromDate',
				endDateField : 'examCancellationApplicableTillDate',
				listeners:{
					render: function(field) {
						return dateFormatRender(field);
					},
					change:function(obj, newValue, oldValue, eOpts){
						obj.nextSibling().setMinValue(newValue);
					}
				}
			}, {
				xtype : 'datefield',
				width : 220,
				fieldLabel : getCommonTranslation('EXAM_CANCELLATION_APPLICABLE_TILL_DATE'),
				name : 'examCancellationApplicableTillDate',
				itemId : 'examCancellationApplicableTillDate',
				startDateField : 'examCancellationApplicableFromDate',
				listeners:{
					render: function(field) {
						return dateFormatRender(field);
					},
					change:function(obj, newValue, oldValue, eOpts){
						obj.previousSibling().setMaxValue(newValue); 
					}
				}
			}]
		}]
	}
	]
	},{
		xtype:'fieldset',
		title: getCommonTranslation('ELIGIBILITY_DETAILS'),
		layout:'vbox',
		frame:true,	
		width:'100%',
		collapsible:true,
		collapsed:false,
		margin: '20 0 0 0',
		itemId:'otherDetailsContId',
		layout : {
			type : 'vbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'fieldcontainer',
			width : '100%',
			itemId:'promotionparameterFieldsetItemId',
			fieldLabel:getProgramandcourseTranslation('PERIOD_PROMOTION_PARAMETER') ,
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'fieldcontainer',
				width: 500,
				defaults :{
					width: 500,
					labelAlign:'top'
				},
				items:[{
					xtype: 'radiogroup',
					itemId:'isPromotionParamCourseTypeId',
					defaults: {
						flex: 1
					},
					items:[{ boxLabel: getCourseTxCommonTranslation('COURSES'), name:'isPromotionParamCourseType', inputValue: 'Y', checked:true },
					       { boxLabel: getCourseTxCommonTranslation('CREDITS'), name:'isPromotionParamCourseType',inputValue: 'N'},
					       { boxLabel: getCourseTxCommonTranslation('COURSES_AND_CREDITS'), name:'isPromotionParamCourseType',itemId:'isPromotionParamCourseType',inputValue: 'CC'}					       
					]
				}]},{
					xtype : 'panel',
					itemId:'anyPromotionParameterFieldsetItemId',
					layout:'vbox',
					autoScroll: true,
					cls:'anyPromotionContainerCLS',
					style:{
						'overflow-x': 'auto !important;'
	    			},
					width: '100%',
					//itemId:'promotionparameterFieldsetItemId',
					//fieldLabel:getProgramandcourseTranslation('PERIOD_PROMOTION_PARAMETER') ,
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{
					xtype : 'fieldcontainer',
	    			width: '100%',
	    			defaults : {
	    				labelAlign : 'top',
	    				width:'226'
	    			},
	    			layout : {
	    				type : 'hbox'
	    			},
	    			items:[{
	    		
					xtype : 'panel',
					width : '80%',
					itemId:'anyMainContainerPanel'+new Date().getTime(),
					style:{
    					border: '1px SOLID #d9d8d8',
    					padding:'15px !important',
    					marginLeft:'0px !important'
    				},
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{

			    		xtype:'panel',
			    		itemId:'panelIdH0',
			    		itemIdx: 0,
			    		layout : 'vbox',
			    		width: '100%',
			    		cls: 'innerPnlPD',
			    	    margin: '0 10 25 0',
			    		items:[{
			    			xtype : 'fieldcontainer',
			    			layout : 'hbox',
			    			width: '100%',
			    			margin: '0 10 8 0',
			    			cls: 'InnerFieldContainerPnl',
			    			defaults : {
			    				labelAlign : 'top',
			    				width:'226'
			    			},
			    			layout : {
			    				type : 'hbox'
			    			},
			    			items:[{
			    				xtype: 'multiselectcombofield',
			    				name: 'periodIds',
			    				width:227,
			    				itemId: 'periodIds',
			    				fieldLabel: getProgramandcourseTranslation('PERIOD'),
			    				store: Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgramPeriodPromotionCriteriaStore'),
			    				displayField:'value',
			    				valueField:'id',
			    				//queryParam:'programName',
			    				//typeAhead : false,
			    				autoloadStore: false,
			    				allowBlank:true,
			    				forceSelection:true,
			    				hideTrigger:false,
			    				triggerAction: 'all',
			    				//disabled:true,
			    				//minChars:3,
			    				//cls:'ProgramCourseMultiselectField',
			    				//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    				listConfig: {
			    					listeners: {
		        						beforeshow: function(picker) {
		        							var pickerComboVal = picker.up('combobox').value;
			    							picker.minWidth = picker.up('combobox').getSize().width;
			    							var getPhPanel =  picker.up('programperiodformwindow').down("#"+picker.up().up().ownerCt.itemId);
		        							var periodArray = [], selectedIds = [];
		        							
		        							if(!isNullOrEmpty(pickerComboVal)){
		        								pickerComboVal = pickerComboVal.filter(function( element ) {
		        									return element !== undefined;
		        								});
		        								if(typeof pickerComboVal[0] == "object"){
			        								selectedIds = Ext.Array.pluck(Ext.Array.pluck(pickerComboVal,'data'),'id');
		        								}
		        								else {
		        									selectedIds = pickerComboVal;
		        								}
		        							}
		        							
		        							getPhPanel.getRefItems().forEach(function(getPhPanelofPanel){
		        								for(var i in getPhPanelofPanel.items.items[0].getValue()){
		        								if(typeof getPhPanelofPanel.items.items[0].getValue()[i] == "object" && getPhPanelofPanel.items.items[0].getValue()[i] != undefined){
	        										periodArray.push(getPhPanelofPanel.items.items[0].getValue()[i].data.id)
	        									}
	        									else if(typeof getPhPanelofPanel.items.items[0].getValue()[i] == "number"){
	        										periodArray.push(getPhPanelofPanel.items.items[0].getValue()[i])
	        									}
		        								}
              							});
		        							
		        							if(periodArray.length>0 && selectedIds.length>0){
		        								for(var j in selectedIds){
		        									var index = periodArray.indexOf(selectedIds[j]);
		        									if (index > -1) {
		        										periodArray.splice(index, 1);
		        									}
		        								}
		        							}
		        							
		        							var store = picker.up('multiselectcombofield').getStore();
		        							store.clearFilter(true);
		        							setTimeout(function(){
			        							store.filterBy(function(record, id){
			        								return !Ext.Array.contains(periodArray, id);
			        							});
		        							},300);
		        						}
		        					
			    					},
			    					loadingText: getCommonTranslation('SEARCHING'),
			    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    					getInnerTpl: function() {
			    						return '<div class="search-item">' +
			    						'{value}'  +
			    						'</div>';
			    					}
			    				}
			    			},
			    			{
			    				xtype: 'numberfield',
			    				name: 'courseToBePassed',
			    				itemId: 'courseToBePassed',
			    				fieldLabel: getProgramandcourseTranslation('NUMBER_OF_COURSES_TO_BE_PASSED'),
			    				disabled: true,
			    				minValue : 0,
			    				maxValue: 100,
			    				mouseWheelEnabled :false,
			    				hideTrigger :true,
			    				allowExponential:false,
			    				allowDecimals:false,
			    				width:226,
			    				allowBlank:false
			    			},{
			    				xtype: 'multiselectcombofield',
			    				name: 'courseToBePassMandetoryIds',
			    				width:227,
								//margin: '0 10 -10 0',
			    				itemId: 'courseToBePassMandetoryIds',
			    				fieldLabel: getProgramandcourseTranslation('COURSES_TO_BE_PASS_MANDATORY'),
			    				store: Ext.create('Academia.store.program.programDetails.programBatches.programCourse.ProgramPeriodCoursesStore'),
			    				displayField:'value',
			    				valueField:'id',
			    				disabled: true,
			    				autoloadStore: false,
			    				allowBlank:true,
			    				forceSelection:true,
			    				hideTrigger:false,
			    				triggerAction: 'all',
			    				hidden:true,
			    				listConfig: {
			    					listeners: {
			    						beforeshow: function(picker) {
			    							var pickerComboVal = picker.up('combobox').value;
			    							picker.minWidth = picker.up('combobox').getSize().width;
			    							var periodIdList = picker.up('programperiodformwindow').getForm().getValues().periodIds;
		        							var periodArray = [], selectedIds = [];
		        							
		        							if(!isNullOrEmpty(pickerComboVal)){
		        								pickerComboVal = pickerComboVal.filter(function( element ) {
		        									return element !== undefined;
		        								});
		        								if(typeof pickerComboVal[0] == "object"){
			        								selectedIds = Ext.Array.pluck(Ext.Array.pluck(pickerComboVal,'data'),'id');
		        								}
		        								else {
		        									selectedIds = pickerComboVal;
		        								}
		        							}
		        							
		        							for(var i in periodIdList){
	        									if(typeof periodIdList[i] == "object" && periodIdList[i] != undefined){
	        										periodArray.push(periodIdList[i].data.id)
	        									}
	        									else if(typeof periodIdList[i] == "number"){
	        										periodArray.push(periodIdList[i])
	        									}
	        								}
		        							
		        							if(periodArray.length>0 && selectedIds.length>0){
		        								for(var j in selectedIds){
		        									var index = periodArray.indexOf(selectedIds[j]);
		        									if (index > -1) {
		        										periodArray.splice(index, 1);
		        									}
		        								}
		        							}
		        							
		        							var store = picker.up('multiselectcombofield').getStore();
		        							store.clearFilter(true);
		        							setTimeout(function(){
			        							store.filterBy(function(record, id){
			        								return !Ext.Array.contains(periodArray, id);
			        							});
		        							},300);
			    						}
			    					},
			    					loadingText: getCommonTranslation('SEARCHING'),
			    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    					getInnerTpl: function() {
			    						return '<div class="search-item">' +
			    						'{value}'  +
			    						'</div>';
			    					}
			    				}
			    			},
			    			{    
			    				xtype:'numberfield',
			    				itemId:'totalCredit',
			    				name:'totalCredit',
			    				fieldLabel: getCourseTxCommonTranslation('CREDITS'),
			    				disabled: true,
			    				minValue : 0,
			    				maxValue: 1000,
			    				mouseWheelEnabled :false,
			    				hideTrigger :true,
			    				allowExponential:false,
			    				allowDecimals:true,
			    				decimalPrecision: 2,
			    				width:226,
			    				allowBlank:true,
			    				hidden:true
			    			},
			    			{
			    				xtype: 'button',
			    				itemId: 'addMorePromotionParamBtn',
			    				name: 'addMorePromotionParamBtn',
			    				width: 'auto',
			    				cls: 'CustomBodyBtnSettings',
			    				width: 'auto',
			    				text: getCommonTranslation('ADDBUTTONTEXT'),
			    				tooltip: getCommonTranslation('ADD'),
			    				style:{
			    					marginTop:'30px'
			    				}
			    			}]
			    		}]
					
					},{
						xtype:'fieldcontainer',
						width:'100%',
						layout: {
							type: 'hbox'
						},
						defaults :{
							width: 226,
							labelAlign:'top'
						},
						items: [{

							xtype: 'customcombobox',
							name: 'progressStatus',
							itemId: 'progressStatusId',
							fieldLabel:getCommonTranslation('PROGRESSION_STATUS'),
							store:Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgressionStatusPeriodStore'),
							valueField: 'id',
							displayField: 'value',
							typeAhead:false,
							triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
							enableKeyEvents  : 'true',
							hideTrigger:false,
							allowBlank:false,
							editable: false,
							disabled:true,
							forceSelection:true,
							listConfig: {
		    					listeners: {
		    						beforeshow: function(picker) {
		    							var pickerComboVal = picker.up('combobox').value;
		    							picker.minWidth = picker.up('combobox').getSize().width;
		    							var progressIdList = picker.up('programperiodformwindow').getForm().getValues().progressStatus;
	        							var progressArray = [], selectedIds = [];
	        							
	        							if(!isNullOrEmpty(pickerComboVal)){
	        								if(typeof pickerComboVal[0] == "object"){
		        								selectedIds = Ext.Array.pluck(Ext.Array.pluck(pickerComboVal,'data'),'id');
	        								}
	        								else {
	        									selectedIds = pickerComboVal;
	        								}
	        							}
	        							
	        							for(var i in progressIdList){
        									if(typeof progressIdList[i] == "object" && progressIdList[i] != undefined){
        										progressArray.push(progressIdList[i].data.id)
        									}
        									else if(typeof progressIdList[i] == "number"){
        										progressArray.push(progressIdList[i])
        									}
        								}
	        							
	        							if(progressArray.length>0 && selectedIds.length>0){
	        								for(var j in selectedIds){
	        									var index = progressArray.indexOf(selectedIds[j]);
	        									if (index > -1) {
	        										progressArray.splice(index, 1);
	        									}
	        								}
	        							}
	        							
	        							var store = picker.up('customcombobox').getStore();
	        							store.clearFilter(true);
	        							setTimeout(function(){
		        							store.filterBy(function(record, id){
		        								return !Ext.Array.contains(progressArray, id);
		        							});
	        							},300);
		    						}
		    					},
		    					loadingText: getCommonTranslation('SEARCHING'),
		    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    					getInnerTpl: function() {
		    						return '<div class="search-item">' +
		    						'{value}'  +
		    						'</div>';
		    					}
		    				}
						
						},{
							xtype:'numberfield',
							itemId:'minimumCreditsForPromotionItemId',
							name:'minimumCreditsForPromotion',
							fieldLabel: getCommonTranslation('MINIMUM_CREDITS_FOR_PROMOTION'),
							minValue : 0,
							maxValue: 999,
							mouseWheelEnabled :false,
							hideTrigger :true,
							disabled: true,
							allowExponential:false,
							allowDecimals:true,
							decimalPrecision: 2,
							allowBlank:true
						}]
					}]
	    			},{
	    	    		xtype: 'button',
	    	    		text: getCommonTranslation('Any'),
	    	    	    itemId: 'addMoreAnyPromotionBtn',
	    	    	    cls:'anyButtonCLS',
	    				name: 'addMoreAnyPromotionBtn',
	    	    		buttonAlign: 'left',
	    	    		margin:'80 0 0 0',
	    	    		ui: 'CustomBtnSubmit',
	    	    		scale: CONSTANTS.BUTTONSIZE
	    	    	}/*,{
						xtype: 'button',
						glyph: ICONGLYPH.DELETEGLYPH,
						margin:'80 0 10 10',
						itemId: 'deleteMoreAnyPromotionBtn',
						width: 'auto',
						cls: 'CustomBodyBtnReject',
						tooltip: getCommonTranslation('DELETETOOLTIP'),
					
	    			}*/]
		}]
		}]
		},{
		xtype:'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
		items: [/*{
			xtype:'numberfield',
			itemId:'minimumCreditsForPromotionItemId',
			name:'minimumCreditsForPromotion',
			fieldLabel: getCommonTranslation('MINIMUM_CREDITS_FOR_PROMOTION'),
			minValue : 0,
			maxValue: 999,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			allowDecimals:true,
			decimalPrecision: 2,
			allowBlank:true
		},*/{
			xtype:'numberfield',
			itemId:'minimumSGPAForPromotionItemId',
			name:'minimumSGPAForPromotion',
			fieldLabel: getProgramandcourseTranslation('MINIMUM_SGPA_FOR_PROMOTION'),
			minValue : 0,
			maxValue: 10,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			allowDecimals:true,
			decimalPrecision: 2,
			allowBlank:true
		},{
			xtype:'numberfield',
			itemId:'minimumCGPAForPromotionItemId',
			name:'minimumCGPAForPromotion',
			fieldLabel: getCommonTranslation('MINIMUM_CGPA_FOR_PROMOTION'),
			minValue : 0,
			maxValue: 10,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			allowDecimals:true,
			decimalPrecision: 2,
			allowBlank:true
		}]
	},{
			xtype: 'fieldcontainer',
			width:'100%',
			itemId:'criteriaDetailsItemIds',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				xtype:'customcombobox',
				name:'programPeriodEndMessageType',
				fieldLabel:getProgramandcourseTranslation('PROGRAM_PERIOD_END_MESSAGE_TYPE'),
				hidden:true
//				translationKey: 'PROGRAM_PERIOD_END_MESSAGE_TYPE',
			},{
				xtype: 'customcombobox',
				name: 'entryCriteriaQuery',
				fieldLabel:getCommonTranslation('PERIOD_ENTER_CRITERIA'),
				//store:Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgramPeriodOtherRuleStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				editable: false,
				disabled:false,
				forceSelection:true
			}, {
				xtype: 'customcombobox',
				name: 'exitCriteriaQuery',
				fieldLabel: getCommonTranslation('PERIOD_EXIT_CRITERIA'),
				store:Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgramPeriodOtherRuleStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				editable: false,
				disabled:false,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name:'drools',
				itemId:'droolsItemId',
				store:Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgramPeriodOtherRuleStore'),
				fieldLabel:getProgramandcourseTranslation('OTHER_RULE_APPLICABLE'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				editable: false,
				disabled:false,
				//width:226,
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			itemId:'promotionDeatilsItemId',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items: [{
					xtype: 'customcombobox',
					name:'programPeriodResponsible',
					store: 'course.CourseCoordinatorSmartSearch',
					fieldLabel: getCommonTranslation('PROGRAM_PERIOD_RESPONSIBLE'),
//					translationKey: 'PROGRAM_PERIOD_RESPONSIBLE',
					valueField: 'id',
					displayField: 'value',
					queryParam:'codeOrName',
					minChars:3,
					//allowBlank: false,
					typeAhead:false,
					hideTrigger:true,
					forceSelection:true,
					hidden:true,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
					xtype: 'fieldcontainer',
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items:[{
						xtype: 'radiogroup',
						fieldLabel: getCommonTranslation('PROGRAM_PERIOD_AUTO_PROMOTION'),
//						translationKey: 'PROGRAM_PERIOD_AUTO_PROMOTION',
						itemId:'programPeriodAutoPromotion',
						name:'programPeriodAutoPromotion',
						defaults: {
							flex: 1
						},
						items:[
						       { boxLabel: 'Yes',name:'programPeriodAutoPromotion', inputValue: 'Y'},
						       { boxLabel: 'No', name:'programPeriodAutoPromotion',inputValue: 'N', checked:true}
						       ]
					}]},{
						xtype: 'fieldcontainer',
						defaults :{
							width: 226,
							labelAlign:'top'
						},
						items:[{
							xtype: 'radiogroup',
							itemId:'programPeriodExternalPromotionId',
							name:'programPeriodExternalPromotionId',
							fieldLabel: getCommonTranslation('PROGRAM_PERIOD_EXTERNAL_PROMOTION'),
//							translationKey: 'PROGRAM_PERIOD_EXTERNAL_PROMOTION',
							defaults: {
								flex: 1
							},
							items:[
							       { boxLabel: 'Yes', name:'programPeriodExternalPromotion',inputValue: 'Y'},
							       { boxLabel: 'No', name:'programPeriodExternalPromotion',inputValue: 'N', checked:true}
							       ]
						}]},{
							xtype: 'radiogroup',
							hidden:true,
							width: 450,
							fieldLabel: getCommonTranslation('STUDENT_JOURNEY_PROMOTION_SEQUESNCE'),
							itemId: 'studentJourneyPeriodSequesnce',
							name: 'studentJourneyPeriodSequesnce',
							allowBlank: false,
							items:[{ 
								boxLabel: getCommonTranslation('YES'),
								name:'isStudentJourneyPeriodSequesnce',
								inputValue: true 
							},{ 
								boxLabel: getCommonTranslation('NO'), 
								name:'isStudentJourneyPeriodSequesnce',
								inputValue: false,
								checked:true
							}]
						}	
					]}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			hidden:true,
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'fieldcontainer',
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items:[{
					xtype: 'radiogroup',
					itemId:'programPeriodStartNotifyId',
					fieldLabel:getCommonTranslation('PROGRAM_PERIOD_START_NOTIFY') ,
//					translationKey: 'PROGRAM_PERIOD_START_NOTIFY',
					defaults: {
						flex: 1
					},
					items:[{ boxLabel: 'Yes', name:'programPeriodStartNotify', inputValue: 'Y', checked:true },
					       { boxLabel: 'No', name:'programPeriodStartNotify',inputValue: 'N'}
					]
				}]},{
					xtype: 'fieldcontainer',
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items:[{
						xtype: 'radiogroup',
						itemId:'programPeriodEndNotifyId',
						fieldLabel: getCommonTranslation('PROGRAM_PERIOD_END_NOTIFY'),
//						translationKey: 'PROGRAM_PERIOD_END_NOTIFY',
						items:[{ boxLabel: 'Yes',name:'programPeriodEndNotify', inputValue: 'Y', checked:true },
						       { boxLabel: 'No', name:'programPeriodEndNotify',inputValue: 'N'}
						]
					}]}
				,{
					xtype:'customcombobox',
					name:'programPeriodStartMessageType',
					fieldLabel:getCommonTranslation('PROGRAM_PERIOD_START_MESSAGE_TYPE'), 
//					translationKey: 'PROGRAM_PERIOD_START_MESSAGE_TYPE',
					store:'',
					valueField:'',
					displayField:''
				}]
		},{
			xtype: 'fieldcontainer',
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{    
				xtype:'numberfield',
				itemId:'minResidenceCredits',
				name:'minResidenceCredits',
				fieldLabel: getProgramandcourseTranslation('MIN_RESIDENCE_CREDITS'),
				minValue : 0,
				maxValue: 999999,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:true,
				decimalPrecision: 2,
				width:226,
				allowBlank:true,
				hidden:true
			}]}
		
		],
	    listeners: {
	        afterrender: function(fieldset) {
	            Ext.EventManager.onWindowResize(function() {
	                fieldset.updateLayout();
	            });
	        }
	    }
	},{
		xtype:'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'programPeriodsFormSubmit',
			buttonAlign: 'right',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel', 
			itemId: 'programPeriodsFormCancel',
			scale: CONSTANTS.BUTTONSIZE

		}]
	}]
//	}]
});