var CreditTypeStoreForTransferCredit = Ext.create('Academia.store.coursetransaction.homework.CreditTypeDropDown');

/**
 * @author bhanu ps
 */
Ext.define('Academia.view.program.transfercredits.AddTransferCreditGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.addtransfercreditgrid',
	store: 'program.transfercredit.AddTrensferCreditGridStore',
	title: getCommonTranslation('LIST_OF_COURSES'),
	border: true,
	autoScroll: false,
	frame:false,
	transferCreditStore:CreditTypeStoreForTransferCredit,
	//enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	cls: 'trCreaditMarkParetDiv1',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	/*dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.transfercredit.AddTrensferCreditGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],*/
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype : 'button',		
		text:getProgramandcourseTranslation('ENTER_EXTERNAL_COURSE_INSTITUTE'),
		itemId:'addExternalCourseInstitute',
		disabled:true
	},{
		xtype: 'fieldcontainer',
		style:{
			//marginLeft:'10px !important'
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'saveBtn',
			ui: 'CustomBtnSubmit',
			disabled:true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('DELETE'),
			itemId: 'btnDelete',
			ui: 'CustomBtnSubmit',
			disabled:true,
			scale: CONSTANTS.BUTTONSIZE
		}]
	}],
	columns: [{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex: 'courseCodeName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_TYPE') ,
		dataIndex: 'courseName',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(value,meta,record){
			if(!record.data.whetherOptional){
				return 'Mandatory';
			} else {
				return 'Optional'
			}
		}
	},{
		header:  getCommonTranslation('CREDITS'),
		dataIndex: 'courseCredits',
		flex:.1,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				return val;
			}else {
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header:  getCommonTranslation('Transfer_Credit_Status'),
		dataIndex: 'status',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				return getCommonTranslation(''+val);
			}else {
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER'); 
			}	
		}
	},{
		header:  getCommonTranslation('MARKS'),
		dataIndex: 'marksObtained',
		sortable: true,
		flex:.1,
		editor: {
				xtype: 'numberfield',
				name:'marksObtained',
				itemId:'marksItemId',
				maxLength: 4,
				minValue:0,
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				if(!isNaN(parseFloat(val))) {
					return val;
				} else {
					return 'N/A';
				}
			}else {
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header:  getCommonTranslation('GRADE'),
		dataIndex: 'gradeObtained',
		flex:.1,
		sortable: true,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor',{
				cls: 'trCreaditGradeParentDiv',
        		field: Ext.create( 'Ext.form.field.ComboBox', {   
			itemId:'marks',
			name:'marksItemId',
			displayField: 'gradeName',
			valuefield:'gradeName',
			store: Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades'),
			editable:false,
			queryMode:'local',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
					combo.bindStore(store);
				}
			},
			listeners: {
    			blur: function(combo, r) {
    				var grid = Ext.ComponentQuery.query('addtransfercreditgrid')[0];
    				var selectionModel = grid.getSelectionModel().getSelection();
    				var gradeType = null;
    				if(selectionModel.length>0){
    					gradeType = selectionModel[0].data.courseGradeType;
    				}
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().setExtraParam('gradeType',gradeType);
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				var grid = combo.up('addtransfercreditgrid');
    				var selectionModel = grid.getSelectionModel().getSelection();
    				var gradeType = null;
    				if(selectionModel.length>0){
    					gradeType = selectionModel[0].data.courseGradeType;
    				}
    				var batchId = grid.getStore().getProxy().extraParams.batchId;
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().setExtraParam('gradeType',gradeType);
    					
    				});
    				combo.getStore().load();
    			}
    		}
		})
		})
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
					if(isNaN(parseFloat(val))) {
						var grid = view.up();
						var models = grid.getStore().getRange();
						var store = Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
						store.getProxy().extraParams={
							gradeType:record.data.courseGradeType,
							whetherSpecialGrade:true
						}
						if(isNullOrEmpty(models[rowIndex].get('gradePoints'))){
							store.load({
								callback:function(records) {
									for(var i in records){
										if(records[i].data.gradeName == val){
											models[rowIndex].set('gradePoints',records[i].data.gradePoint);
										}
									}
								}
							});
						}
						return val;
				} else {
					return 'N/A';
				}
			}else {
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header:  getProgramandcourseTranslation('EXTERNAL_COURSE_CODE'),
		dataIndex: 'externalCourseCode',
		flex:.1,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor',{
				cls: 'trCreaditGradeParentDiv',
        		field: Ext.create( 'Ext.form.field.Text', {
        			name:'exCourseCode',
        			itemId:'exCourseCode',
        			maxLength: 50,
        		})
        	});
        },
		renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
	},{
		header:  getProgramandcourseTranslation('EXTERNAL_COURSE_NAME'),
		dataIndex: 'externalCourseName',
		flex:.1,
		getEditor: function(record) {	
			return Ext.create('Ext.grid.CellEditor',{
				cls: 'trCreaditGradeParentDiv',
        		field: Ext.create( 'Ext.form.field.Text', {
        			name:'exCourseName',
        			itemId:'exCourseName',
        			maxLength: 255,
        		})
        	});
		},
		renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
		
	},{
		header:  getProgramandcourseTranslation('EXTERNAL_COURSE_INSTITUTE'),
		dataIndex: 'externalCourseInstitute',
		flex:.1,
		getEditor: function(record) {
	    	return Ext.create('Ext.grid.CellEditor',{
	    		cls: 'trCreaditGradeParentDiv',
	    		field: Ext.create('Ext.form.field.Text',{
	    			name:'exCourseInstitute',
	    			itemId:'exCourseInstitute',
	    			maxLength: 250,
	    		})
	    	})			
		},
		renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
		
	},{
		header:  getProgramandcourseTranslation('EXTERNAL_COURSE_GRADE'),
		dataIndex: 'externalCourseGrade',
		flex:.1,
		getEditor : function(record) {
			return Ext.create('Ext.grid.CellEditor',{
				cls: 'trCreaditGradeParentDiv',
				field: Ext.create('Ext.form.field.Text',{
					name:'exCourseMarks',
					itemId:'exCourseMarks',
					maxLength: 50,
				})
			})
		},
		renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
	},{
		header:  getProgramandcourseTranslation('EXTERNAL_COURSE_MARKS'),
		dataIndex: 'externalCourseMarks',
		flex:.1,
		getEditor : function(record) {
			return Ext.create('Ext.grid.CellEditor',{
				cls: 'trCreaditGradeParentDiv',
				field: Ext.create('Ext.form.field.Text',{
					name:'exCourseMarks',
					itemId:'exCourseMarks',
					maxLength: 50,
				})
			})
		},
		renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
	},{
		header:  getCommonTranslation('HR_CREDIT_TYPE'),
		dataIndex: 'creditTypeId',
		flex:.1,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor',{
				cls: 'trCreaditGradeParentDiv',
        		field: Ext.create( 'Ext.form.field.ComboBox', {
			itemId:'creditTypeCombo',
			name:'creditTypeCombo',
			displayField: 'value',
			valuefield:'id',
			store: CreditTypeStoreForTransferCredit,
			editable:false,
			listeners: {
				focus : function(combo) {
					var value=combo.getValue();
					if(!isNullOrEmpty(value)){
						var index=CreditTypeStoreForTransferCredit.findExact('id',value);
						if(index!=-1){
							combo.setValue(CreditTypeStoreForTransferCredit.getAt(index).data.value);
						}
					}
				}
			}})
        	});
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				var index=CreditTypeStoreForTransferCredit.findExact('id',val);
				if(index!=-1){
					return CreditTypeStoreForTransferCredit.getAt(index).data.value;
				}
				return val;
			}
		}
	},{ 
		header : getProgramandcourseTranslation('COMPLETION_DATE'),
		dataIndex : 'completionDate',
		flex : .1,
		editor: {
			xtype: 'datefield',
			name: 'completionDate',
			itemId:'completionDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			editable:true,

		},
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}                        
		}
	
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context){
				var grid = obj.view.up();
				var store = grid.getStore();
				var models = grid.getStore().getRange();
				if(!isNullOrEmpty(editor.record.data.status) && getCommonTranslation(editor.record.data.status).toUpperCase() == getCommonTranslation('COMPLETED').toUpperCase()){
					if(editor.column.text == getCommonTranslation('MARKS')) {
							return false;
					} else {
						models[editor.rowIdx].set('allowToEdit',true);
						if(editor.column.text == getCommonTranslation('GRADE')){
							/*editor.column.field.reset();
							var store = editor.column.field.getStore();
							if(!isNullOrEmpty(editor.record.data.courseGradeType)) {
								store.getProxy().extraParams={
									gradeType:editor.record.data.courseGradeType
								};
								store.load();
							}*/
							return false;
						}
					}
				}
				if(!isNullOrEmpty(editor.record.data.status) && getCommonTranslation(editor.record.data.status).toUpperCase() == getCommonTranslation('ENROLLED').toUpperCase()){
					if(editor.column.text == getCommonTranslation('MARKS')||editor.column.text == getCommonTranslation('HR_CREDIT_TYPE')
							||editor.column.text == getProgramandcourseTranslation('EXTERNAL_COURSE_MARKS')||editor.column.text ==getProgramandcourseTranslation('EXTERNAL_COURSE_GRADE')
							||editor.column.text == getProgramandcourseTranslation('EXTERNAL_COURSE_INSTITUTE')||editor.column.text ==  getProgramandcourseTranslation('EXTERNAL_COURSE_NAME')
							||editor.column.text ==  getProgramandcourseTranslation('EXTERNAL_COURSE_NAME')||editor.column.text == getProgramandcourseTranslation('EXTERNAL_COURSE_CODE')
							) {
							return false;
					} else {
						models[editor.rowIdx].set('allowToEdit',true);
						if(editor.column.text == getCommonTranslation('GRADE')){
							return false;
						}
					}
				}
			}
		}
	}]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1
});
