/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.program.uploaddownload.BulkTransferDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.bulktransferdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	width:'auto',
	height:'auto',
	items : [{
		xtype:'fieldset',
		layout:'vbox',
		frame:true,	
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		style: {
			marginTop: '10px!important'
		},
		items:[{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
				name: 'academyLocation',
				itemId:'academyLocationCombo',
				store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
				displayField: 'value',
				valueField: 'id',
				width:460,
				queryParam:'qry',
				typeAhead: false,
				forceSelection: true,
				triggerAction: 'all',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				allowBlank: false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM'),
				name: 'program',
				itemId:'programCombo',
				queryMode : 'local',
				editable: false,
				store: 'common.ProgramByAcademyLocationStoreWithoutPermission',
				displayField: 'valueCode',
		        valueField: 'id',
		        autoloadStore: false,
				allowBlank: false,
				disabled: true
			}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('BATCH'),
				editable: false,
				disabled: true,
				store:'common.BatchesByProgramId',
				name: 'batch',
				itemId: 'batchId',
				valueField: 'id',                
				displayField: 'value',
				allowBlank: false
			},{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('PERIOD'),
				editable: false,
				disabled: true,
				store:'program.programDetails.programBatches.courseParameter.EnrollmentProgramCoursePeriod',
				name: 'period',
				itemId: 'periodId',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false
			},{
				xtype : 'customcombobox',
				name : 'downloadType',
				itemId:'downloadTypeItemId',
				fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),	
				store:'program.ProgramTemplateBulkTransferStore',
				valueField : 'id',
				displayField : 'value',
				triggerAction : 'all',
				editable : false,
				allowBlank : false
			}]	
		}],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
	},{
		xtype: 'button',
		text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
		itemId: 'downoladBtnId',
		hidden:false,
		disabled:true,
		ui: 'CustomBtnSubmit'
	}]
});
