/**
 * @author priyanshi sharma
 * 
 */
Ext.define('Academia.view.receipt.receiptsettings.StatementEmailSettingGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.statementemailsettinggrid',
	title: getFeeAndPaymentCommonTranslation("SEARCH_RESULT"),
	store:'receipt.receiptsettings.StatementEmailPBSTMappingGridStore',
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'receipt.receiptsettings.StatementEmailPBSTMappingGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getFeeAndPaymentCommonTranslation("ACADEMY_LOCATION"),
		dataIndex:'academyLocationName',
		flex:.1,
		sortable:true
	},{
		header:  getFeeAndPaymentCommonTranslation("PROGRAM"),
		dataIndex:'programName',
		flex:.1,
		sortable:true
	},{
		header:  getFeeAndPaymentCommonTranslation("BATCH"),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true,
	},{
		header:  getFeeAndPaymentCommonTranslation("SEAT_TYPE"),
		dataIndex: 'seatName',
		flex:.1,
		sortable:true,
	}]
});