/**
 * @author Pravin.Surve
 * this is Quick search Form Provisional and trial admission
 */
Ext.define('Academia.view.reports.admission.ProvisionalAndTrialAdmissionReportSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.provisionalandtrialadmissionreportsearchform',
    frame: false,
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        itemId: 'admissionReportprogrmBatchSeatTypeContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width:226,
			typeAhead:true,
			forceSelection:true,
			 store:Ext.create('Academia.store.common.IntakeYearStore'),
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
	/*		listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}*/
		},{
	       	 xtype: 'customcombobox',
	    	 fieldLabel: getCommonTranslation('PROGRAM'),
//	    	 translationKey : 'PROGRAM',
	         name: 'PROGRAM',
	         itemId: 'programId',
	         valueField: 'id',                
	         displayField: 'value',
	         queryMode: 'local',
	         autoload: false,
	         typeAhead: true,
             forceSelection: true,
             store :Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds'),
             triggerAction: 'all',
             minChars:3,
             emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	   /*      listeners: {
	                render: function(combo) {
	                    var store = Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds');
	                    combo.bindStore(store);
	                }
	            }*/
	    },{
	        xtype: 'customcombobox',
	        fieldLabel: getCommonTranslation('BATCH'),
	        editable: false,
	        disabled: true,
	        name: 'BATCH',
	        itemId: 'batchId',
	        valueField: 'id',                
	        displayField: 'value',
	        queryMode: 'local',
	        listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
	    },{
	        xtype: 'customcombobox',
	        fieldLabel: getCommonTranslation('SEAT_TYPE'),
	        editable: false,
	        disabled: true,
	        name: 'SEAT_TYPE',
	        itemId: 'seatTypeId',
	        valueField: 'seatTypeId',                
	        displayField: 'seatTypeName',
	        queryMode: 'local',
	        listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                    combo.bindStore(store);
                }
            }
    }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'admissionReportQuotaTypeContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('QUOTA_TYPE'),
            editable: false,
            name: 'QUOTA_TYPE',
            itemId: 'quotaTypeId',
            displayField: 'code',
            valueField: 'id',
            queryMode: 'remote',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.selectionProcess.QuotaTypes');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('QUOTA'),
            editable: false,
            disabled: true,
            name: 'QUOTA',
            itemId: 'quotaId',
            displayField: 'code',
            valueField: 'id',
            queryMode: 'remote',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.quotas.QuotaLists');
                    combo.bindStore(store);
                }
            }
        },{
        	xtype:'customcombobox',
            fieldLabel: getAdmissionTranslation('ADMISSION_STATUS'),   //Admission Status
            name: 'ADMISSION_STATUS',
            itemId: 'admissionStatus',
            editable: false,
            queryMode:'local',
            displayField:'display',
            valueField:'value',
            forceSelection:true
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        fieldLabel : getAdmissionTranslation('ADMISSION_DATE_BETWEEN'),
        labelWidth : 226,
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getAdmissionTranslation('START_DATE'),
            name: 'START_DATE',
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
            itemId:'startDateId',
            vtype: 'daterange',
			endDateField: 'endDateId'
        },{
            xtype: 'datefield',
            fieldLabel: getAdmissionTranslation('END_DATE'),
            name: 'END_DATE',
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            itemId:'endDateId',
            vtype: 'daterange',
			startDateField: 'startDateId'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        fieldLabel : getAdmissionTranslation('TRIAL_END_DATE_BETWEEN'),
        labelWidth : 226,
        itemId:'trialEndDateSelector',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getAdmissionTranslation('START_DATE'),
            name: 'TRIAL_START_DATE',
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
            itemId:'trialStartDateId',
            vtype: 'daterange',
			endDateField: 'trialEndDateId'
        },{
            xtype: 'datefield',
            fieldLabel: getAdmissionTranslation('END_DATE'),
            name: 'TRIAL_END_DATE',
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            itemId:'trialEndDateId',
            vtype: 'daterange',
			startDateField: 'trialStartDateId'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        fieldLabel : getAdmissionTranslation('PROVISIONAL_END_DATE_BETWEEN'),
        itemId:'provisionalEndDateSelector',
        labelWidth : 226,
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getAdmissionTranslation('START_DATE'),
            name: 'PROVISIONAL_START_DATE',
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
            itemId:'proStartDateId',
            vtype: 'daterange',
			endDateField: 'proEndDateId'
        },{
            xtype: 'datefield',
            fieldLabel: getAdmissionTranslation('END_DATE'),
            name: 'PROVISIONAL_END_DATE',
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            itemId:'proEndDateId',
            vtype: 'daterange',
			startDateField: 'proStartDateId'
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getAdmissionTranslation('SEARCH'),
            itemId: 'provisionalTrialFindButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getAdmissionTranslation('CLEAR_SEARCH'),
            itemId: 'provisionalTrialClearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});