/**
 * This view is used for the Quota Overrides report quick search form.
 * @author Pravin.Surve
 */
Ext.define('Academia.view.reports.admission.QuotaOverridesReportQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.quotaoverridesreportquicksearchform',
    cls:'customSearchPanel',
    frame: false,
    items: [{
        xtype: 'fieldcontainer',
        itemId: 'quotaOverrideprogrmBatchSeatTypeContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
	       	 xtype: 'customcombobox',
	    	 fieldLabel: getCommonTranslation('PROGRAM'),
//	    	 translationKey : 'PROGRAM',
	         name: 'programId',
	         itemId: 'programId',
	         valueField: 'id',                
	         displayField: 'value',
	         queryMode: 'local',
	         autoload: false,
	         store : Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds'),
	         typeAhead: true,
             forceSelection: true,
             triggerAction: 'all',
             minChars:3,
             queryParam:'programName',
             enableKeyEvents:true,
             emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	         listeners: {
	              /*  render: function(combo) {
	                    var store = Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds');
	                    combo.bindStore(store);
	                },*/
	                focus: function(combo){
	        	 		combo.expand();
	        	 		combo.onTriggerWrapClick();
	        		},
	        		delay: 1,
	                keypress:function(combo,eOpt){
	                	if(combo.getValue().length > 2){
	                		combo.queryMode = "remote";
	                	}
	                }
	            }
	    },{
	        xtype: 'customcombobox',
	        fieldLabel: getCommonTranslation('BATCH'),
	        editable: false,
	        name: 'batchId',
	        itemId: 'batchId',
	        valueField: 'id',                
	        displayField: 'value',
	        queryMode: 'local',
	        listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
	    },{
	        xtype: 'customcombobox',
	        fieldLabel: getCommonTranslation('SEAT_TYPE'),
	        editable: false,
	        name: 'seatTypeId',
	        itemId: 'seatTypeId',
	        valueField: 'seatTypeId',                
	        displayField: 'seatTypeName',
	        queryMode: 'local',
	        listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                    combo.bindStore(store);
                }
            }
    }]
    },{
        xtype: 'fieldcontainer',
        itemId: 'quotaOverrideSelectionComboContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
    		xtype: 'customcombobox',
    		width: 226,
    		itemId: 'selectionStageCombo',
    		name: 'programSelectionProcessStageId',
    		fieldLabel: getAdmissionTranslation('SELECT_STAGE'),
    		labelAlign: 'top',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.selectionStage.SelectionStageFromSeatType');
                    combo.bindStore(store);
                }
            }
    	}]
    },  {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'quotaOverridesReportSearchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getAdmissionTranslation('CLEAR_SEARCH'),
            itemId: 'quotaOverridesReportClearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]

    }]

});