/**
 * @author Amit Gupta
 * 
 */
Ext.define('Academia.view.reports.admission.dashboard.AdmissionSummaryApprovedGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.admissionsummaryapprovedgrid',
	store : 'reports.admission.AdmissionSummaryApprovedStore',
	border : true,
	cls: 'enqgridsummarycls',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar:['->',{
		xtype: 'splitbutton',
		itemId: 'btnExportToPDFJasper',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-pdf-icon',
		menu: [{
			text: getAdmissionTranslation('EXPORT_CURRENT_PAGE'),
			itemId: 'exportPDFCurrentPage'
		}]
	},{
		xtype: 'splitbutton',
		itemId: 'btnExportToExcelJasper',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-excel-icon',
		menu: [{
			text: getAdmissionTranslation('EXPORT_CURRENT_PAGE'),
			itemId: 'exportExcelCurrentPage'
		}]
	}],
	features: [{
		id: 'group',
		ftype: 'groupingsummary',
		groupHeaderTpl: '{name}',
		hideGroupedHeader: false,
		enableGroupingMenu: true
	},{
		ftype: 'summary',
		dock: 'bottom'
	}],
	columns: [{
        text: getEnquiryTranslation('ACADEMY_LOCATION'),
        flex: 1,
        tdCls: 'task',
        dock:'top',
        sortable: true,
        dataIndex: 'programName',
        hideable: false,
        align:'center',
        summaryType: 'count',
        summaryRenderer: function(value, summaryData, dataIndex) {
        	var text = "Total";
        	if(dataIndex.internalId.indexOf('summary') > 0){
        		text = getAdmissionTranslation('GRAND_TOTAL');
        	}
            return text;//((value === 0 || value > 1) ?  text + value : text + 1);
         }
        },{
        	text: getAdmissionTranslation('TOTAL_ADMISSION'),
        	flex: 1,
        	sortable: true,
        	dataIndex: 'totalAdmission',
        	align:'center',
        	summaryType: 'sum'
        }, {
        	text: getAdmissionTranslation('WM_OF_ADMISSION'),
        	flex: 1,
        	sortable: true,
        	dataIndex: 'wmofAdmission',
        	align:'center',
        	summaryType: 'sum'
        }, {
        	text: getAdmissionTranslation('CONVERSION_PERCENTAGE_FROM_APPLICATIONS'),
        	flex: 1,
        	sortable: true,
        	dataIndex: 'conPercFromAs',
        	align:'center',
        	summaryType: 'sum',
        	renderer:function(val,rec,e){
        		if(!isNullOrEmpty(val)){
        			return val.toFixed(2) + "%" ;
        		} else {
        			return '';
        		}
        	},
            summaryRenderer: function(value, summaryData, data) {
    			var totalConvAdmissions = 0;
    			var totalAdmission = data.get('totalAdmission');
            	var totalSucessfulApplication = data.get('totalSucessfulApplication');
            	if(data.internalId.indexOf('summary') > 0){
            		var range = this.getStore().getRange();
            		range.forEach(function(obj){
            			totalConvAdmissions = totalConvAdmissions+obj.get('totalSucessfulApplication');
            		});
            	} else {
            		totalConvAdmissions = data.get('totalSucessfulApplication');
            	}
            	if(totalConvAdmissions!=0){
            		var conversionAdmPercentage = (totalAdmission/totalConvAdmissions)*100;
            	}
            	if(!isNullOrEmpty(conversionAdmPercentage)){
            		return conversionAdmPercentage.toFixed(2) + "%" ;
            	} else {
            		return '';
            	}
            },
        }, {
        	text: getAdmissionTranslation('TARGET_FOR_ADMISSION'),
        	flex: 1,
        	sortable: true,
        	dataIndex: 'targetForAdmission',
        	align:'center',
        	summaryType: 'sum'
        }, {
        	text: getAdmissionTranslation('PERCENTAGE_TO_TARGET_FOR_ADMISSION'),
        	flex: 1,
        	sortable: true,
        	dataIndex: 'perOfTargetForAdmission',
        	align:'center',
        	renderer:function(val,rec,e){
        		if(!isNullOrEmpty(val)){
        			return val.toFixed(2) + "%" ;
        		} else {
        			return '';
        		}
        	},
        	summaryRenderer: function(value, summaryData, data) {
            	var totalAdmission = data.get('totalAdmission');
            	var targetForAdmission = data.get('targetForAdmission');
            	if(targetForAdmission!=0){
            		var perOfTargetForAdmissions = (totalAdmission/targetForAdmission)*100;
            	}
            	if(!isNullOrEmpty(perOfTargetForAdmissions)){
            		return perOfTargetForAdmissions.toFixed(2) + "%" ;
            	} else {
            		return '';
            	}
            }
        }, {
        	text: getAdmissionTranslation('YOY_VARIANCE_ADMISSION_TARGET_TO_DATE'),
        	flex: 1,
        	sortable: true,
        	dataIndex: 'yoyTotalAdmission',
        	align:'center',
        	summaryType: 'sum',
        	renderer:function(val,rec,e){
        		if(!isNullOrEmpty(val)){
        			return val.toFixed(2) + "%" ;
        		} else {
        			return '';
        		}
        	},
        	summaryRenderer: function(value, summaryData, data) {
        		var totalADMYOY = 0;
    			var totalSuccessFulAdd = data.get('totalAdmission');
            	var previousTotalAdmissions = data.get('previousTotalAdmissions');
            	if(data.internalId.indexOf('summary') > 0){
            		var range = this.getStore().getRange();
            		range.forEach(function(obj){
            			totalADMYOY = totalADMYOY+obj.get('previousTotalAdmissions');
            		});
            	} else {
            		totalADMYOY = data.get('previousTotalAdmissions');
            	}
            	if(totalADMYOY!=0){
            		var perOfADMYOY = ((totalSuccessFulAdd-totalADMYOY)/totalADMYOY)*100;
            	}
            	if(!isNullOrEmpty(perOfADMYOY)){
            		return perOfADMYOY.toFixed(2) + "%" ;
            	} else {
            		return '';
            	}
            }
        },{
    		text: getAdmissionTranslation('TOTAL_SUCCESSFUL_APPLICATIONS'),
    		flex: 1,
    		hidden:true,
    		sortable: true,
    		dataIndex: 'totalSucessfulApplication',
    		summaryType: 'sum',
    		hideMode:'display'
    	},{
    		text: getAdmissionTranslation('PREVIOUS_YEAR_TOTAL_ADMISSIONS'),
    		flex: 1,
    		hidden:true,
    		sortable: true,
    		dataIndex: 'previousTotalAdmissions',
    		summaryType: 'sum',
    		hideMode:'display'
    	}]
});