/**
 * @author Amit G
 * 
 */
Ext.define('Academia.view.reports.admission.dashboard.ApplicationCommentsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicationcommentsgrid',
	store : 'reports.admission.ApplicationCommentsGridStore',
	cls:'enqgridsummarycls',
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'reports.admission.ApplicationCommentsGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header:   getEnquiryTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocation',
		flex:.1
	},{
		header:  getCommonTranslation('APPLICATION_ID'),
		dataIndex: 'applicationCode',
		flex:.1
	},{
		header:  getAdmissionTranslation('APPLICANT_NAME'),
		dataIndex: 'applicantName',
		flex:.1
	},{
		header:  getCommonTranslation('FATHERS_NAME'),
		dataIndex: 'guardianName',
		flex:.1
	},{
		header:  getAdmissionTranslation('PROGRAM'),
		dataIndex: 'program',
		flex:.1
	},{
		header:  getAdmissionTranslation('BATCH'),
		dataIndex: 'intake',
		flex:.1
	},{
		header:  getAdmissionTranslation('APPLICATION_APPROVED_COMMENTS'),
		dataIndex: 'applicationApprovedComments',
		flex:.1
	},{
		header:  getAdmissionTranslation('APPLICATION_REJECTED_COMMENTS'),
		dataIndex: 'applicationRejectedComments',
		flex:.1
	},{
		header:  getAdmissionTranslation('APPLICATION_WITHDRAWN_COMMENTS'),
		dataIndex: 'applicationWithdrawnComments',
		flex:.1
	},{
		header:  getAdmissionTranslation('ASSESSMENT_STAGE_COMMENTS'),
		dataIndex: 'assessmentStageComments',
		flex:.1
	},{
		header:  getAdmissionTranslation('ADMISSION_APPROVED_COMMENTS'),
		dataIndex: 'admissionApprovedComments',
		flex:.1
	},{
		header:  getAdmissionTranslation('ADMISSION_REJECTED_COMMENTS'),
		dataIndex: 'admissionRejectedComments',
		flex:.1
	},{
		header:  getAdmissionTranslation('ADMISSION_WITHDRAWN_COMMENTS'),
		dataIndex: 'admissionWithdrawnComments',
		flex:.1
	}]
});