/**
 * @author priyanshi Sharma
 */
var billType = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"ALL", "name":getCommonTranslation("ALL")},
        {"value":"P_AND_C_FEE", "name":getCommonTranslation("P_AND_C_FEE")},
        {"value":"SERVICE_PROVIDED", "name":getCommonTranslation("SERVICE_PROVIDED")},
        {"value":"SCHOLARSHIP", "name":getCommonTranslation("SCHOLARSHIP")},
        {"value":"SERVICE_RECEIVED", "name":getCommonTranslation("SERVICE_RECEIVED")},
        {"value":"LATE_FEE", "name":getCommonTranslation("LATE_FEE")}] 
});
Ext.define('Academia.view.reports.admission.dashboard.dtefInvoices.DtefInvoicesFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.dtefinvoicesfilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    margin: '8 0 25 0',
    padding: 8,
    layout: 'vbox',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'program',
            itemId: 'programIdInvoices',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            store: 'common.ProgramsByAcademyIdLocationId',
            valueField: 'id',
            displayField: 'valueCode',
            valueField: 'id',
            forceSelection: true,
            queryParam: 'qry',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'batch',
            itemId: 'batchIdInvoices',
            fieldLabel: getCommonTranslation('BATCH'),
            store: 'common.BatchesByProgramId',
            valueField: 'id',
            displayField: 'value',
            disabled: true,
            forceSelection: true,
            queryParam: 'qry',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'periodId',
            itemId: 'periodIdInvoices',
            fieldLabel: getCommonTranslation('PERIOD'),
            store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
            valueField: 'id',
            displayField: 'value',
            editable: false,
            disabled: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'responseStatus',
            itemId:'responseStatusInvoices',
            fieldLabel: getCommonTranslation('RESPONSE_STATUS'),
            displayField: 'value',
            valueField: 'name',
            allowBlank: true,
            store: Ext.create('Academia.store.common.ResponseStatusStore')
        }, {
            xtype: 'customcombobox',
            name: 'response',
            itemId: 'responseIdInvoices',
            fieldLabel: getCommonTranslation('RESPONSE'),
            store: Ext.create('Academia.store.common.DTEFInvoicesResponseStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            queryParam: 'name',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ADMISSION_STATUS'),
            name: 'admissionstatus',
            itemId: 'admissionStatusInvoices',
            editable: false,
            store: Ext.create('Academia.store.common.AdmissionStatusStore'),
            valueField: 'name',
            displayField: 'value'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDateInvoices',
            vtype: 'daterange',
            endDateField: 'tillDateInvoices',
            allowBlank: true,
            maxValue: new Date(),
            fieldLabel: getCommonTranslation('FROM_DATE'),
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'tillDateInvoices',
            vtype: 'daterange',
            allowBlank: true,
            startDateField: 'fromDateInvoices',
            maxValue: new Date(),
            fieldLabel: getCommonTranslation('TILL_DATE'),
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('INTAKE_YEAR'),
            name: 'intakeYear',
            itemId: 'intakeYearInvoices',
            displayField: 'value',
            valueField: 'id',
            allowBlank: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            minChars:3,
            forceSelection: true,
            listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			},
            listeners: {
                render: function (combo) {
                    var store = Ext.create('Academia.store.common.IntakeYearByBatchStore');
                    combo.bindStore(store)
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'studentNameSearch',
            itemId: 'studentFieldItemIdInvoices',
            store: 'common.DTEFInvoicesAdmissionIdStudentIdStore',
            fieldLabel: getCommonTranslation('ADMISSIONCODE_STUDENTNAME_STUDENTCODE'),
            width: 462,
            valueField: 'id',
            displayField: 'value',
            queryParam: 'name',
            minChars: 3,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            typeAhead: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection: true,
            allowBlank: true,
            matchFieldWidth: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'billType',
            itemId: 'billTypeInvoices',
            fieldLabel: getCommonTranslation('BILL_TYPE'),
            store:billType,
            valueField: 'value',
            displayField: 'name',
            value:'ALL',
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'nationalId',
            itemId: 'nationalIdItemIdInvoices',
            store: 'common.DTEFInvoicesNationalIdStore',
            fieldLabel: getCommonTranslation('NATIONAL_ID'),
            valueField: 'id',
            displayField: 'id',
            queryParam: 'name',
            minChars: 3,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            typeAhead: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection: true,
            allowBlank: true,
            matchFieldWidth: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'dtefInvoiceSearchBtnId',
            formBind: true,
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'dtefInvoiceResetBtnId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});