/**
 * @author Pritam.Patil
 * This view is used for the Faculty Follow up scheduled quick search form
 */
Ext.define('Academia.view.reports.faculty.FacultyFollowUpScheduledSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultyfollowupscheduledsearchform',
    defaults: {
        labelAlign: 'top'
    },
    frame: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'requestsubrequesttypefieldcontainer',
        itemId: 'requestTypeFieldContainer',
        layout: 'hbox'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'livesearchcombo',
            name: 'requesterId',
            fieldLabel: getPersonModuleTranslation('REQUESTER_NAME'),
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            itemId: 'requesterNameId' ,
     		listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintPersons');
                    store.getProxy().api.read = SERVERURL.COMPLAINT_FACULTY_COMBO;
                    combo.bindStore(store);
                }
            },
            displayTpl: new Ext.XTemplate('<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["value"]]}' +
             		'</tpl>'
             		)
             		
             		
        },{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
            queryMode:'local',
            editable: false,
            name: 'departmentId',
            itemId: 'departmentCombo',
            valueField: 'id',
            displayField: 'value',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SUB_DEPARTMENT'),
            
            editable: false,
            queryMode: 'local',
            name: 'subDepartmentId',
            itemId: 'subDepartmentCombo',
            valueField: 'id',
            displayField: 'name',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.department.SubDepartmentComboStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('REQUEST_BY'),
            name: 'requesterType',
            itemId: 'requestTypeItemId',
            valueField: 'value',
            displayField: 'name', 
            allowBlank: false,
            editable: false,
            querymode: 'local',
            listeners:{
            	render: function(combo){
            		var store = Ext.create('Academia.store.servicerequest.common.RequestBy');
            		combo.bindStore(store);
                	combo.store.clearFilter(true);
                    combo.store.filter({
                        filterFn: function(record) {
                            var flag = true;
                            if (record.get('value') == 'STUDENT' || record.get('value') == 'FACULTY') {
                                flag = true;
                            } else {
                                flag = false;
                            }
                            return flag;
                        }
                    }, this);
                    combo.setValue('FACULTY');
                }
            }
        }, {
            xtype: 'datefield',
            itemId: 'startDate',
            fieldLabel: getServiceRequestTranslation('FROM_DATE'),
            name: 'startDate',
            vtype: 'daterange',
            endDateField: 'endDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }, {
            xtype: 'datefield',
            name: 'endDate',
            fieldLabel: getServiceRequestTranslation('TILL_DATE'),
            itemId : 'endDate',
            vtype: 'daterange',
            startDateField: 'startDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            disabled: true,
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});