/**
 * @author Pritam.Patil
 * This view is used for the Faculty Extra curr.activity report quick search form
 */
Ext.define('Academia.view.reports.faculty.personaldetails.FacultyExtraCurricularActivityReportSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultyextracurricularactivityreportsearchform',
    frame: false,
    cls:'customSearchPanel', 
    height: '30%',
    layout: 'vbox',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID'),
            
            name: 'FACULTY_ID'
        }, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SELECT_NAME'),
            
            store: 'common.SelectNameComboStore',
            editable: false,
            queryMode: 'local',
            name: 'selectedNameField',
            itemId: 'selectedNameFieldId',
            valueField: 'id',
            displayField: 'value',
            value: 'FIRST_NAME'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
            
            itemId: 'selectedName',
            name: 'FIRST_NAME'
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'progrmBatchCourseContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programComboField',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            
            displayField: 'valueCode',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchComboField',
            fieldLabel: getCommonTranslation('BATCH'),
            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'courseId',
            itemId: 'courseComboField',
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//            editable: false,
            queryMode: 'courseName',
            valueField: 'id',
            displayField: 'valueCode',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.scholarships.ScholarshipCoursesStore');
                    combo.bindStore(store);
                }
            },
            queryParam:'courseName',
			minChars:3,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('SPECIFIC_ACTIVITY'),
            
            name: 'SPECIFIC_ACTIVITY'
        }]
     }, {
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});