Ext.define('Academia.view.reports.systemutilization.onlineusers.OnlineUserReportGroupWiseSummaryGraph', {
    extend: 'Ext.chart.Chart',
    alias: 'widget.onlineuserreportgroupwisesummarygraph',
    width: 600,
    height: 300,
    animate: true,
    store: 'reports.systemutilization.onlineusers.OnlineUserReportModuleWiseSummaryGraphStore',
    axes: [{
        type: 'Numeric',
        position: 'left',
        fields: ['data'],
        label: {
            renderer: Ext.util.Format.numberRenderer('0,0')
        },

        grid: true,
        minimum: 0
    }, {
        type: 'Category',
        position: 'bottom',
        fields: ['name']

    }],
    series: [{
        type: 'column',
        axis: 'left',
        highlight: true,
        tips: {
            trackMouse: true,
            width: 80,
            height: 18,
            renderer: function(storeItem, item) {
                this.setTitle(storeItem.get('name') + ': ' + storeItem.get('data') + ' $');
            }
        },
        label: {
            display: 'insideEnd',
            'text-anchor': 'middle',
            field: 'data',
            renderer: Ext.util.Format.numberRenderer('0'),
            orientation: 'vertical',
            color: '#333'
        },
        xField: 'name',
        yField: 'data'
    }]
});