/**
 * @author Suraj Chouhan
 * 
 */
Ext.define('Academia.view.scholarship.managescholarship.ManageScholarshipDownloadTemplateForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managescholarshipdownloadtemplateform',
	//plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
	items : [
	   {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',			
			cls:'multiBrandCampusCls',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            name: 'academyLocation',
            itemId:'academyLocationComboId',
            store: 'user.UserAcademyLocationStore',
            width:460,
            queryParam:'qry',
            displayField: 'value',
            valueField: 'id',
            typeAhead : true,
            allowBlank:false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			autoloadStore: false,
			maxLength: 10000,
			minChars:3,
			cls:'ProgramCourseMultiselectField',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]},
		{

			xtype: 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top'
			},
			items: [{
				xtype: 'customcombobox',
	            name: 'accountingYear',
	            itemId: 'accountingYearId',
	            fieldLabel: getCommonTranslation('ACCOUNTING_YEAR'),
	            valueField: 'id',
	            displayField: 'currentAccountingYear',
	            forceSelection:true,
	            allowBlank: false,
				typeAhead:false,
				editable: false,
				store:Ext.create('Academia.store.scholarships.FindAllAccountingYear'),
				width:226,
			},{
				xtype: 'customcombobox',
	            name: 'applicableFor',
	            itemId: 'applicableForId',
	            fieldLabel: getCommonTranslation('APPLICABLE_FOR'),
	            editable: false,
	            displayField: 'value',
	            valueField: 'id',
	            store:Ext.create('Academia.store.scholarships.ApplicableTypeStore'),
	            forceSelection:true,
	            allowBlank: false,
	            width:226,
			},{
				xtype: 'customcombobox',
	            itemId:'templateForId',
	            editable: false,
	            displayField: 'value',
	            valueField: 'id',
	            fieldLabel: getCommonTranslation('TEMPLATE_FOR'),
	            name: 'templateFor',
	            store:Ext.create('Academia.store.scholarships.TemplateForTypeStore'),
	            forceSelection:true,
	            allowBlank: false,
	            width:226,
			},{
				xtype: 'customcombobox',
	            itemId:'scholarshipCategoryId',
	            editable: false,
	            displayField: 'value',
	            valueField: 'id',
	            queryMode: 'local',
	            fieldLabel: getCommonTranslation('SCHOLARSHIP_CATEGORY'),
	            name: 'scholarshipCategory',
	            store:Ext.create('Academia.store.scholarships.ScholarshipCategoryStore'),
	            forceSelection:true,
	            allowBlank: false,
	            width:226,
			}]
		
		},
    {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',			
            name: 'programName',
            cls:'multiBrandCampusCls',
            itemId: 'programItemId',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            store:Ext.create('Academia.store.common.ProgramAssociatedWithPeriodByAcadLocation'),
            width:410,
            disabled:true,
            queryParam:'qry',
            displayField: 'valueCode',
            valueField: 'id',
            typeAhead : true,
            allowBlank:false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			maxLength: 10000,
			autoloadStore: false,
			minChars:3,
			cls:'ProgramCourseMultiselectField',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),            
            listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation('SEARCHING'),
 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					 '{code} / {value}'+ 
 					'</div>';
 				}
 			}
		},{
			xtype: 'multiselectcombofield',
            name: 'batchName',
            itemId: 'batchItemId',
            cls:'multiBrandCampusCls',
            fieldLabel: getCommonTranslation('BATCH'),
            disabled:true,
            width:280,
            queryParam:'qry',
            displayField: 'value',
            valueField: 'id',
            typeAhead : true,
            allowBlank:true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			maxLength: 10000,
			autoloadStore: false,
			minChars:3,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            store:'common.BatchesAssociatedWithPeriodByAcadAndProgram',
            listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation('SEARCHING'),
 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					 '{code} / {value}'+ 
 					'</div>';
 				}
 			}
		},{
			xtype: 'multiselectcombofield',
			name: 'periodName',
            itemId:'periodItemId',
            cls:'multiBrandCampusCls',
            fieldLabel: getCommonTranslation('PERIOD'),
            disabled:true,
            width:280,
            queryParam:'name',
            displayField: 'value',
            valueField: 'id',
            typeAhead : true,
            allowBlank:true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			autoloadStore: false,
			maxLength: 10000,
			minChars:3,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.ParameterizedPeriodByBatch',
            listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation('SEARCHING'),
 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					 '{code} / {value}'+ 
 					'</div>';
 				}
 			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			labelAlign: 'top'
		}
		},
    {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items: [{
           	 xtype: 'button',
        	 text: getCommonTranslation('DOWNLOAD_TEMPLATE'),
             itemId: 'downoladTemplateBtnId',
             formBind : true,
             ui: 'CustomBtnSubmit'
        },{
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
	}]
});