Ext.define('Academia.view.scholarship.scholarshiplisting.ScholarshipApplicantAwardeeListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.scholarshipApplicantAwardeeListGrid',
	store: 'scholarships.ScholarshipAwardeeStore',
	title: getCommonTranslation('APPLICANT_SCHOLARSHIP_AWARDEES_LIST'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'scholarshipServiceListMaster':1
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'scholarships.ScholarshipAwardeeStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'transferScholarshipApplicant',
		tooltip: getCommonTranslation('TRANSFER_SCHOLARSHIP'),
		text: getCommonTranslation('TRANSFER_SCHOLARSHIP'),
	},'->'],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('SCHOLARSHIP_APPLICATION_ID'),
		dataIndex:'scholarshipApplicationId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('APPLICANT_ID'),
		dataIndex:'applicantId',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			return record.get('applicantCode');
		}
	},{
		header:  getCommonTranslation('APPLICANT_NAME'),
		dataIndex:'applicantName',
		flex:.1,
		sortable:true
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex:'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('INTAKE'),
		dataIndex:'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SCHOLARSHIP_CATEGORY'),
		dataIndex:'scholarshipCategory',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			if(!isNullOrEmpty(record.get("scholarshipCategory"))) {
				switch(record.get("scholarshipCategory")) {
				case 'DEPARTMENTAL':
					return 'Departmental';
					break;
				case 'NOMINATION':
					return 'Nomination Based';
					break;
				case 'NSFAS':
					return 'NSFAS Based';
					break;
				case 'NRF':
					return 'NRF Based';
					break;
				default:
					return value;
				break;
				}

			} 
			return value;
		}
	},{
		header:  getCommonTranslation('SCHOLARSHIP_ID'),
		dataIndex:'scholarshipId',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			return record.get('scholarshipCode');
		}
	},{
		header:  getCommonTranslation("SCHOLARSHIP_NAME"),
		dataIndex:'scholarshipName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SCHOLARSHIP_AMOUNT_TYPE'),
		dataIndex:'amountType',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			if(!isNullOrEmpty(record.get("amountType"))) {
				switch(record.get("amountType")) {
				case 'FIX':
					return 'Fixed Amount';
					break;
				case 'ADH':
					return 'Adhoc';
					break;
				default:
					return value;
				break;
				}

			} 
			return value;R
		}
	},{
		header:  getCommonTranslation('AMOUNT'),
		dataIndex:'amount',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex:'status',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			if(!isNullOrEmpty(record.get("status"))) {
				switch(record.get("status")) {
				case 'AWARD_ACTIVATION_PENDING':
					return getCommonTranslation("AWARD_ACTIVATION_PENDING");
					break;
				case 'SCHOLARSHIP_ACTIVATED':
					return getCommonTranslation("AWARDED");
					break;
				case 'REJECTED':
				case 'AWARD_ACTIVATION_REJECTED': 
					return getCommonTranslation("REJECTED");
					break;
				default:
					break;
				}
			} 
			return value;
		}
	}]
});
