Ext.define('Academia.view.scholarship.scholarshiplisting.ScholarshipStudentAwardeeListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.scholarshipStudentAwardeeListGrid',
	store: 'scholarships.ScholarshipAwardeeStore',
	title: getCommonTranslation('STUDENT_SCHOLARSHIP_AWARDEES_LIST'),
	border: true,
	frame:false,
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'scholarshipServiceListMaster':1
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'scholarships.ScholarshipAwardeeStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		disabled:true,
		itemId: 'activateScholarshipStudent',
		tooltip: getCommonTranslation('ACTIVATE_SCHOLARSHIP'),
		text: getCommonTranslation('ACTIVATE_SCHOLARSHIP'),
	},'->'],
	columns: [{
		header:  getCommonTranslation('SCHOLARSHIP_APPLICATION_ID'),
		dataIndex:'scholarshipApplicationId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex:'studentId',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			return record.get('studentCode');
		}
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex:'studentName',
		flex:.1,
		sortable:true
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex:'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('INTAKE'),
		dataIndex:'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SCHOLARSHIP_CATEGORY'),
		dataIndex:'scholarshipCategory',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			if(!isNullOrEmpty(record.get("scholarshipCategory"))) {
				switch(record.get("scholarshipCategory")) {
				case 'DEPARTMENTAL':
					return 'Departmental';
					break;
				case 'NOMINATION':
					return 'Nomination Based';
					break;
				case 'NSFAS':
					return 'NSFAS Based';
					break;
				case 'NRF':
					return 'NRF Based';
					break;
				default:
					return value;
				break;
				}

			} 
			return value;
		}
	},{
		header:  getCommonTranslation('SCHOLARSHIP_ID'),
		dataIndex:'scholarshipId',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			return record.get('scholarshipCode');
		}
	},{
		header:  getCommonTranslation("SCHOLARSHIP_NAME"),
		dataIndex:'scholarshipName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SCHOLARSHIP_AMOUNT_TYPE'),
		dataIndex:'amountType',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			if(!isNullOrEmpty(record.get("amountType"))) {
				switch(record.get("amountType")) {
				case 'FIX':
					return 'Fixed Amount';
					break;
				case 'ADH':
					return 'Adhoc';
					break;
				default:
					return value;
				break;
				}
			} 
			return value;R
		}
	},{
		header:  getCommonTranslation('AMOUNT'),
		dataIndex:'amount',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex:'status',
		flex:.1,
		sortable:true,
		renderer: function(value,meta,record) {
			if(!isNullOrEmpty(record.get("status"))) {
				switch(record.get("status")) {
				case 'AWARD_ACTIVATION_PENDING':
					return getCommonTranslation("AWARD_ACTIVATION_PENDING");
					break;
				case 'SCHOLARSHIP_ACTIVATED':
					return getCommonTranslation("AWARDED");
					break;
				case 'REJECTED':
				case 'AWARD_ACTIVATION_REJECTED':  
					return getCommonTranslation("REJECTED");
					break;
				default:
					break;
				}
			} 
			return value;
		}
	},
	{
		header:  getCommonTranslation('ACTION_BY'),
		dataIndex:'actionByUserName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SCHOLARSHIP_ACTIVE_DATE'),
		dataIndex:'scholarshipActiveDate',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			if(!Ext.isEmpty(value)) {
				return dateRender(value);
			}
			return value
		}
	}]
});
