Ext.define('Academia.view.scholarship.scholarshipmaster.AddPeriodForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.addperiodformWindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('ADD_PERIOD'),
    initComponent: function() {
        var me = this;
        Ext.apply(me, {
            items: [{
                xtype: 'form',
                itemId: 'addPeriodForm',
                method: 'POST',
                plugins: "formlabelrequired",
                defaults: {
                    labelAlign: 'top'
                },
                standardSubmit: false,
                items: [{
                    xtype: 'hidden',
                    itemId: 'period_client_Id',
                    name: 'client_Id'
                }, {
                    xtype: 'hidden',
                    itemId: 'PeriodId',
                    name: 'id'
                }, {
                    xtype: 'textfield',
                    fieldLabel: getCommonTranslation('PERIOD_NAME'),
                    name: 'periodName',
                    allowBlank: false
                }, {
                    xtype: 'numberfield',
                    fieldLabel: getCommonTranslation('PERIOD_SEQUENCE'),
                    name: 'periodSequence',
                    allowBlank: false,
                    minValue: 0
                }, {
                    xtype: 'numberfield',
                    fieldLabel: getCommonTranslation('DURATION'),
                    itemId: 'DurationId',
                    name: 'durationInMonth',
                    allowBlank: false,
                    enableKeyEvents: true,
                    minValue: 0,
                    hideTrigger: true,
                    keyNavEnabled: false,
                    mouseWheelEnabled: false
                }, {
                    xtype: 'numberfield',
                    fieldLabel: getCommonTranslation('AMOUNT'),
                    allowBlank: false,
                    name: 'amount',
                    minValue: 0,
                    itemId: 'periodAmount',
                    enableKeyEvents: 'true',
                    hideTrigger: true,
                    keyNavEnabled: false,
                    mouseWheelEnabled: false
                }, {
                    xtype: 'fieldcontainer',

                    items: [{
                        xtype: 'button',
                        itemId: 'btnSaveAddPeriodForm',
                        text: getCommonTranslation('ADD_PERIOD'), //Submit
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true
                    }, {
                        xtype: 'button',
                        itemId: 'btnCancelAddPeriodForm',
                        text: getCommonTranslation('CANCEL'), //Cancel
                        ui: 'CustomBtnCancel',
                        scale: CONSTANTS.BUTTONSIZE
                    }]
                }]

            }]
        });

        me.callParent(arguments);
    }
});