/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of academy locations in grid
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.AssociateAcademyLocationGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.associateacademylocationgrid',
    border: true,
    cls:'centerAlignTitle',
    //autoScroll: true,
    store: 'scholarships.AssociateAcademyLocationGridStore',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    title: getCommonTranslation('LIST_OF_Academy_Location'),		

    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex: .3
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('EMPTY_ACADEMY_LOCATION_MESSAGE'), //No academy locations to display
            store: 'scholarships.AssociateAcademyLocationGridStore'
        }]
    }]
});