/**
 *
 * @author Sooraj Prasad

 */
Ext.define('Academia.view.scholarship.scholarshipmaster.IntelliMaliTransactionForm', {
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.intellimalitransactionform',
	title: getCommonTranslation('ADD_INTELLI_MALI'),
	autoScroll: true,
	bodyStyle: {
		margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	},
	bodyPadding: '10 10 10 11',
	plugins: "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'hidden',
			itemId: 'itellimaliId'
		}, {
			xtype: 'textfield',
			name: 'sequenceNumber',
			itemId: 'sequenceNumber',
			fieldLabel: getCommonTranslation('SEQUENCE_NUM'),
			hidden: true
		}, {
			xtype: 'datefield',
			name: 'transactionDate',
			itemId: 'transactionDate',
			vtype: 'daterange',
			editable: false,
			hidden: true,
			hideTrigger: true,
			fieldLabel: getCommonTranslation('TRANSACTION_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ACCOUNTING_YEAR'),
			name: 'intellimaliAccountingYear',
			itemId: 'intellimaliAccountingYear',
			displayField: 'accountingYear',
			valueField: 'id',
			width: 226,
			editable: false,
			allowBlank: false,
			forceSelection: true,
			typeAhead: false,
			hideTrigger: false,
			store: 'feeandpayment.accountingConfigurationMapping.AccountingYearStore'
		}, {
			xtype: 'customcombobox',
			name: 'institutionId',
			width: 226,
			itemId: 'institutionId',
			store: 'scholarships.InstituteCSMStore',
			fieldLabel: getCommonTranslation('INSTITUTION'),
			valueField: 'id',
			displayField: 'value',
			forceSelection: true,
			editable: false,
			typeAhead: false,
			hideTrigger: false,
			allowBlank: false

		}, {
			xtype: 'customcombobox',
			name: 'student',
			itemId: 'studentId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'scholarships.ScholarshipStudentStore',
			width: 226,
			valueField: 'id',
			displayField: 'valueCode',
			queryParam: 'studentCode',
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents: 'true',
			minChars: 3,
			allowBlank: false,
			typeAhead: false,
			forceSelection: true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
				}
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		layout: {
			type: 'hbox'
		},
		items: [
			{
				xtype: 'customcombobox',
				name: 'academyLocationName',
				itemId: 'academyLocationId',
				fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
				valueField: 'id',
				displayField: 'value',
				store: 'scholarships.ScholarshipsFacultyCampusStore',
				readOnly: false,
				queryMode: "local",
				editable: false,
				allowBlank: false,
				typeAhead: true,
				hidden: false,
				disabled: false,
				forceSelection: true,
				allowBlank: false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
					}
				}
			},
			{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
				name: 'programId',
				itemId: 'programId',
				store: 'scholarships.IntelliMaliActiveProgramStore',
				valueField: 'id',
				displayField: 'valueCode',
				queryMode: 'local',
				queryParam: 'qry',
				allowBlank: false,
				typeAhead: false,
				forceSelection: true
			},
			{
				xtype: 'textfield',
				fieldLabel: getCommonTranslation('SU_NUMBER'),
				name: 'sunumber',
				readOnly: true,
				itemId: 'suNumber',
			}]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		layout: {
			type: 'hbox'
		},
		items: [
			{
				xtype: 'textfield',
				fieldLabel: getCommonTranslation('PASSPORT_NUMBER'),
				itemId: "passportNumber",
				name: 'passportNumber',
				allowBlank: true,
				readOnly: true,
				maxLength: 30,
			}, {
				xtype: 'numberfield',
				fieldLabel: getCommonTranslation('TOTAL_AMOUNT'),
				name: 'totalamount',
				itemId: 'totalamount',
				allowBlank: false,
				hideTrigger: true,
				decimalPrecision: 2,
				maxLength: 15
			}, {
				xtype: 'datefield',
				name: 'payementstartdate',
				itemId: 'payementstartdateId',
				editable: false,
				allowBlank: false,
				fieldLabel: getCommonTranslation('PAYMENT_START_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				minValue: new Date()
			}]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		layout: {
			type: 'hbox'
		},
		items: [
			{
				xtype: 'numberfield',
				fieldLabel: getCommonTranslation('NUMBER_OF_INSTALLMENT'),
				itemId: "numberofinstalment",
				name: 'numberofinstalment',
				allowBlank: false,
				hideTrigger: true,
				maxLength: 2,
				minValue: 1
			},
			{
				xtype: 'textfield',
				fieldLabel: getCommonTranslation('ESTIMATED_MONTHLY_AMOUNT'),
				name: 'estimatedmonthlyinstallment',
				itemId: "estimatedmonthlyinstallment",
				width: 226,
				allowBlank: false,
				maxLength: 30,
			}]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'fit',
		defaults: {
			labelAlign: 'top',
		},
		items: [{
			xtype: 'panel',
			layout: 'hbox',
			defaults: {
				width: 240,
				labelAlign: 'top',
			},
			items: [{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('FUND_ALLOCATION'),
				itemId: 'fundAllocationId',
				name: 'fundAllocation',
				width: 280,
				height: 100,
				allowBlank: false,
				columns: 2,
				items: [{
					boxLabel: getCommonTranslation('Cash'),
					name: 'fundAllocation',
					inputValue: 'CASH'

				}, {
					boxLabel: getCommonTranslation('Books'),
					name: 'fundAllocation',
					inputValue: 'BOOKS'
				}, {
					boxLabel: getCommonTranslation('Meals'),
					name: 'fundAllocation',
					inputValue: 'MEALS',
				}, {
					boxLabel: getCommonTranslation('Accommodation'),
					name: 'fundAllocation',
					inputValue: 'ACCOMMODATION'
				}]
			}, {
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('TRANSACTION_TYPE'),
				itemId: 'transactionTypeId',
				name: 'transactionType',
				width: 260,
				height: 100,
				allowBlank: false,
				columns: 2,
				items: [{
					boxLabel: getCommonTranslation('New'),
					name: 'transactionType',
					inputValue: 'NEW'
				}, {
					boxLabel: getCommonTranslation('Additional'),
					name: 'transactionType',
					inputValue: 'ADDITIONAL'
				}, {
					boxLabel: getCommonTranslation('Substract'),
					name: 'transactionType',
					inputValue: 'SUBSTRACT'
				}, {
					boxLabel: getCommonTranslation('Stop'),
					name: 'transactionType',
					inputValue: 'STOP'
				}]

			}],
		},
		]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('SCHOLARSHIP_ID_NAME'),
			itemId: 'scholarshipId',
			name: 'scholarshipId',
			enableKeyEvents: true,
			// store:'scholarships.ScholarshipIdNameStore',
			store: 'scholarships.IntelliMaliScholarshipBasedStore',
			valueField: 'id',
			displayField: 'valueCode',
			editable: true,
			triggerAction: 'all',
			queryParam: 'qry',
			minChars: 3,
			allowBlank: false,
			typeAhead: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
						'{code}/{value}' +
						'</div>';
				}
			}
		}, {
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ALLOWANCE_PROPOSED'), //Program
			name: 'allowanceproposed',
			itemId: 'allowanceproposed',
			//autoload: true,
			store: 'scholarships.AllowanceProposedStore',
			valueField: 'id',
			displayField: 'code',
			forceSelection: true,
			editable: false,
			typeAhead: false,
			hideTrigger: false
		}, {
			xtype: 'customcombobox',
			name: 'accommodationproviderId',
			itemId: 'accommodationproviderId',
			store: 'hostel.accommodationProvider.IntelliMaliAccommodationProviderGridStore',
			fieldLabel: getCommonTranslation('ACCOMMODATION_PROVIDER'),
			valueField: 'id',
			displayField: 'value',
			width: 226,
			queryParam: 'accommodProviderName',
			minChars: 3,
			typeAhead: false,
			disabled: true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
						'{accommodProviderName}' +
						'</div>';
				}
			}
		}]

	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'textareafield',
			fieldLabel: getCommonTranslation('COMMENTS'),
			name: 'comments',
			width: 226,
			allowBlank: true,
			itemId: 'commentsId',
			maxLength: 750
		}]

	}, {
		xtype: 'fieldcontainer',
		width: '100%',
		style: {
			marginLeft: '12px'
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation("SAVE"),
			itemId: 'submitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		}, {
			xtype: 'button',
			text: getCommonTranslation("UPDATE"),
			itemId: 'updateBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			hidden: true,
			formBind: true
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetButtonId',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId: 'cancelButtonId',
			ui: 'CustomBtnCancel',
			hidden: true,
			scale: CONSTANTS.BUTTONSIZE,
		}]
	}
	]
});