/**
 * 
 * This component is used for to show scholarship receipt search form
 */
Ext.define('Academia.view.scholarship.scholarshipreceipt.ScholarshipReceiptSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.scholarshipeceiptsearchform',
    autoScroll: true,
    frame: false,
    layout: 'vbox',

    items: [{
        xtype: 'form',
        itemId: 'scholarshipReceipt',
        cls: 'customSearchPanel',
        //   method : 'POST',
        width: '100%',
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('SCHOLARSHIP_ID'),
                itemId: 'scholReceipt_scholId',
                name: 'scholarshipId',
                store:'feeandpayment.managebill.ScholarshipSmartSearch',
    			width:226,
    			valueField: 'scholarshipCode',
    			displayField: 'scholarshipNameValue',
    			queryParam:'scholarshipNameOrCode',
    			minChars:3,
    			typeAhead:false,
    			//hideTrigger:true,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			triggerAction: '',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
                	
            }, {
                /*xtype: 'textfield',
                fieldLabel: getCommonTranslation('STUDENT_ID'),
                name: 'studentCode',
                itemId: 'studentId'
            }, {
                xtype: 'textfield',
                fieldLabel: getCommonTranslation('STUDENT_NAME'),
                name: 'studentName',
                itemId: 'studentName'*/
            	
            	
            	xtype: 'customcombobox',
				name:'studentCode',
				itemId:'studentId',
				store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
				fieldLabel:getCommonTranslation('STUDENT_CODE_NAME'),
				valueField: 'code',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code / value}' +
						'</div>';
					}
				}
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('ORGANISATION'),
                name: 'organizationName',
                itemId: 'organizationItemId',
                editable: false,
                store: 'scholarships.Organizations',
                valueField: 'id',
                displayField: 'value',
                queryMode: 'local',
                value: getCommonTranslation('ALL'),
                selectOnFocus: true,
                loading: true
            }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('TRANSACTION_TYPE'),
                name: 'transactionType',
                itemId: 'transactionType',
                editable: false,
                emptyText: getCommonTranslation('SELECT_TRANSACTION_TYPE'),
                store: 'scholarships.TransactionTypes',
                displayField: 'value',
                valueField: 'id',
                value: 'All',
                queryMode: 'local'
            }]
        }, {
        	xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'transactionFromDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				maxValue: new Date()
            }, {
            	xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'transactionToDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            itemId: 'acadLocationPanel',
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('ACADAMY'),
                name: 'academyIds',
                itemId: 'ACADAMY',
                store: 'securitysetup.unlockUser.acadamyStore',
                displayField: 'value',
                valueField: 'id',
                hidden: true
            }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('LOCATION'),
                store: 'organization.academylocations.LocationStore',
                displayField: 'value',
                valueField: 'id',
                name: 'locationIds',
                itemId: 'LOCATION',
                hidden: true
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'radiogroup',
                itemId: 'scholarshipDisbursementMode',
                columns: 2,
                width: '550px',
                vertical: false,
                fieldLabel: getCommonTranslation('DISBURSEMENT_MODE_INT'),
                layout: {
                    type: 'hbox'
                },
                items: [{
                    boxLabel: getCommonTranslation('DIR'),
                    name: 'disbursementMode',
                    inputValue: true,
                    checked: true
                }, {
                    boxLabel: getCommonTranslation('INS'),
                    name: 'disbursementMode',
                    inputValue: false
                }]
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'ScholarshipReceiptSearchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
    			xtype: 'button',
    			text : getCommonTranslation('RESET'),
    			itemId : 'ScholarshipReceiptsResetBtn',
    			ui : 'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    			listeners: {
                    click: function(button, eOpts) {
                    	this.up('form').getForm().reset();
                    }
                }
            }]
        }]
    }]
});