/**
 * This grid is used for the scholarship receipt listing.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.scholarship.scholarshipreceipt.ScholarshipRecieptGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.scholarshiprecieptgrid',
    store: 'scholarships.ScholarshipReceipts',
    title: getCommonTranslation('SCHOLARSHIP_RECEIPT'),
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
    },
    columns: [{
        text: getCommonTranslation('SCHOLARSHIP_ID'),
        dataIndex: 'scholarshipCode',
        flex: 1,
        renderer: function(value) {
            return '<a href="#">' + value + '</a>';
        }
    }, {
        text: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            return '<a href="#">' + value + '</a>';
        }
    }, {
        text: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: 1,
        sortable: true
    }, {
        text: getCommonTranslation('ORGNAME'),
        dataIndex: 'organizationName',
        flex: 1,
        sortable: true
    }, {
        text: getCommonTranslation('ACADEMY_NAME'),
        dataIndex: 'academyName',
        flex: 1,
        sortable: true,
        hidden: true
    }, {
        text: getCommonTranslation('LOCATION_NAME'),
        dataIndex: 'locationName',
        flex: 1,
        sortable: true,
        hidden: true
    }, {
        text: getCommonTranslation('TRANSACTION_TYPE'),
        dataIndex: 'transactionType',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return getCommonTranslation(value);
            }
        }
    }, {
        text: getCommonTranslation('TRANSACTION_DATE'),
        dataIndex: 'transactionDate',
        flex: 1,
        sortable: true,
		renderer : function(date) {
			return dateRender(date);
		}
    }, {
        text: getCommonTranslation('AMOUNT'),
        dataIndex: 'transactionAmount',
        flex: 1,
        renderer:function(value,meta,record){
 			if(!isNullOrEmpty(value)) {
 				if(record.get("isMultiCurrency")==true){
 					return currencyRenderer(value,record.get("currencyId"));
 				}else{
 					return value;
 				}
				
			}                    
		},
        sortable: true
    },{
    	text : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'conversionRate',
		flex : 1,
		hidden:true,
        sortable: false
	},{
		text : getFeeAndPaymentCommonTranslation('CONVERTED_AMOUNT'),
		dataIndex : 'acadLocBaseCurrencyAmount',
		flex : 1,
		hidden:true,
        sortable: false,
        renderer:function(value,meta,record){
 			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}                    
		}
	}, {
        text: getCommonTranslation('VOUCHER_REFERENCE_NO'),
        dataIndex: 'voucherReferenceNumber',
        flex: 1,
        sortable: true
    }, {
        text: getCommonTranslation('INSTRUMENT_NO'),
        dataIndex: 'instrumentNumber',
        flex: 1,
        sortable: true
    }, {
        text: getCommonTranslation('INSTRUMENT_DATE'),
        dataIndex: 'instrumentDate',
        flex: 1,
        sortable: true,
		renderer : function(date) {
			return dateRender(date);
		}
    }, {
        text: getCommonTranslation('INSTRUMENT_DRAWN_ON'),
        dataIndex: 'instrumentDrawnOn',
        flex: 1,
        sortable: true
    }],

    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'scholarships.ScholarshipReceipts',
            emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }]
});