/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.securitygatemanagement.SgAddVisitor',{
	extend:'Academia.view.common.IdGeneratorForm',
	formCode : 'sgaddvisitor',
	alias: 'widget.sgaddvisitor',
	title:getServiceRequestTranslation('SG_ADD_VISITOR_DETAILS'),
	frame:true,
	plugins: "formlabelrequired",
	border: false,
	autoScroll: false,
	 //cls: 'panelNoSpace',
   //  defaultType: 'displayfield',

   collapsible: false,
   items: [{
       xtype: 'fieldcontainer',
       width: '100%',
       defaults: {
           width: '100%'
       },
       layout: {
           type: 'hbox'
       },
       items: [{
           xtype: 'panel',
           frame: false,
           width: '790px',
           style:{marginTop:'-50px'},
           items: [{
               xtype: 'fieldcontainer',
               border: false,
               layout: {
                   type: 'vbox'
               },
               width: '790px',
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'hidden',
		name: 'parentPersonId',
		itemId:'parentPersonId'
	},{
		xtype: 'hidden',
		name: 'person',
		itemId:'person'
	},{
		xtype: 'hidden',
		name: 'personImagePath',
		itemId:'personImagePath'
	},{
		xtype: 'hidden',
		name: 'academyLocationId',
		itemId:'academyLocationId'
	},{
		xtype: 'fieldset',
		itemId : 'personalDetailFieldset',
		style:{marginTop:'-30px'},
		//title: getAdmissionTranslation('DETAILS'), //  Details
		items: [{
			xtype: 'fieldcontainer',
			//style:{marginLeft:'10px'},
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 200
			},
			items: [{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'checkboxfield',
					name: 'isAppointment',
					itemId:'isAppointment',
					boxLabel: getServiceRequestTranslation('SG_APPOINTMENT'),
					inputValue : true,
					uncheckedValue: false 
				}]
			},{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'checkboxfield',
					name: 'isEarlierAppointment',
					itemId:'isEarlierAppointment',
					boxLabel: getServiceRequestTranslation('VISITED_EARLIER'),
					inputValue : true,
					uncheckedValue: false 
				}],
		}]
		},
		{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
		items: [{
			xtype: 'customcombobox',
			name: 'earlierContactId',
			itemId: 'earlierContactId',
			fieldLabel: getServiceRequestTranslation('EARLIER_CONTACT_ID'),
			store:'sgvisitor.SgVisitorEarlierContactIdStore',
			valueField: 'visitorContactNo',
			displayField: 'visitorContactNo',
			queryParam:'earlierContactId',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			hidden:true,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			maxLength:45,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]},{
			xtype: 'fieldcontainer',
			itemId: 'searchComponent',
			//style:{marginLeft:'10px'},
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'visitorCategory',
				itemId: 'visitorCategory',
				fieldLabel: getServiceRequestTranslation('SG_VISITOR_CATEGORY'),
				store:'sgappointment.sgappointment.SGVisitorCategoryStore',
				valueField: 'id',
				displayField: 'value',
				//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				allowBlank: false,
				//value:true,
				//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: 'all',
				hideTrigger:false,
				editable: false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'  +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',
				name: 'visitorNo',
				itemId:'visitorNo',
				fieldLabel: getServiceRequestTranslation('VISITOR_NO'),
				emptyText: getCommonTranslation('ID_AUTOGENERATE'),
			},]
		},{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'bookingId',
				itemId: 'bookingId',
				fieldLabel: getServiceRequestTranslation('BOOKING_ID'),
				store:'sgvisitor.SgVisitorFindByBookingId',
				valueField: 'bookingId',
				displayField: 'bookingId',
				queryParam:'bookingId',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				hidden:true,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				maxLength:45,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
				xtype:'datefield',
				name: 'bookingDate',
				fieldLabel: getServiceRequestTranslation('BOOKING_DATE'),
				itemId:'bookingDate',
				allowBlank: false,
				//value:new Date(),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				//endDateField: 'appointmentId',
				readOnly:true,
				editable: true,
				listeners: {
					render: function(field) {
						field = dateFormatRender(field);						
						field.setValue(new Date());
					}
				},
			
			},]
		},{
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'parentName',
				itemId: 'parentName',
				fieldLabel: getServiceRequestTranslation('PARENT_OR_GUARDIAN'),
				//store: 'sgappointment.sgappointment.SGParentGuardianStore',
				store: 'sgvisitor.SgVisitorDetailsByNameStore',
				valueField: 'id',
				displayField: 'visitorNewName',
				queryParam:'codeOrName',
				allowBlank: false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				forceSelection:true,
				hidden:true,
			//	 width: 300,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				maxLength:255,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',
				fieldLabel: getServiceRequestTranslation('VEHICLE_NO'),
				name: 'visitorVehicleNo',
				itemId: 'visitorVehicleNo',
				//vtype: 'spaceAndSpecialCharactersAsInput',
				maxLength:20,
			}]
		},{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name:'visitorName',
				itemId:'visitorName',
				fieldLabel: getServiceRequestTranslation('VISITOR_NAME'),
				store:'sgvisitor.SgVisitorDetailsByNameStore',
				valueField: 'id',
				displayField: 'visitorNewName',
				queryParam:'codeOrName',
				hidden:true,
				minChars:3,
				allowBlank: false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				maxLength:255,
			   triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			   enableKeyEvents  : 'true',
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					//emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',
				fieldLabel: getServiceRequestTranslation('VISITOR_NAME'),
				name: 'otherVisitor',
				itemId: 'otherVisitor',
				hidden:true,
				maxLength:255
			},{
				xtype: 'fieldcontainer',
				fieldLabel: getAdmissionTranslation('CONTACT_NO'),
				name:'visitorContactNolabel',
				itemId:'visitorContactNolabel',
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype: 'customcombobox',
					valueField: 'isdCode',
					displayField: 'isdCode',
					store:Ext.create('Academia.store.common.CountryStore'),
					itemId:'visitorphoneCountryCode',
					triggerAction: 'all',
					name: 'visitorphoneCountryCode',
					width: 80,
					editable: false,
					forceSelection:true,
					minChars: 1
				}, {
					xtype: 'numberfield',
					name: 'visitorContactNo',
					itemId:'visitorContactNo',
//					fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
					minLength: 0,
					maxLength: 11,
					allowNegative: false,
				    minValue: 1,
					allowBlank:true,
					hideTrigger:true,
					mouseWheelEnabled:false,
					width: 135,
					enforceMaxLength : true,			
					emptyText: 'Mobile Number',
				//allowDecimals : false,
				//	regex:new RegExp('^\\d{1}[.05]*$')
				//regex:new RegExp('^\\d{1,}[.05]*$')
				//regexText: 'decimal are not allowed'
				}]
			},{
				xtype: 'textfield',
				fieldLabel: getServiceRequestTranslation('PARENT_EMAIL_ID'), //Email ID
				name: 'visitorEmailId',
				itemId: 'visitorEmailId',
				vtype: 'email',
				maxLength: 45,
			},]
		}, { 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getServiceRequestTranslation('VISITOR_ORGANIZATION'),
				name: 'visitorOrganization',
				itemId: 'visitorOrganization',
				hidden:true,
				vtype: 'spaceAndSpecialCharactersAsInput',
				maxLength:45,
			},{
				xtype: 'textfield',
				fieldLabel: getServiceRequestTranslation('VISITOR_PLACE'),
				name: 'visitorPlace',
				itemId: 'visitorPlace',
				hidden:true,
				vtype: 'spaceAndSpecialCharactersAsInput',
			    maxLength:45,
			},]
		},{
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'fieldcontainer',        
				width: 236,
				itemId:'fieldcontainerformNoManuallyId',
				items:[{
					xtype: 'radiogroup',
					style:{marginLeft:'-2px !important'},
					itemId:'formNoManuallyId',
					labelAlign: 'top',
					fieldLabel:getServiceRequestTranslation('SG_ASSIGN_PREPRINTED_CARDS'),
					columns: 2,
					vertical: true,
					items: [
					        { boxLabel: getAdmissionTranslation('YES'), name: 'isFormNoManually', inputValue: true,checked:true},
					        { boxLabel: getAdmissionTranslation('NO'), name: 'isFormNoManually', inputValue: false,}
					        ]
				},]
			},{
				xtype: 'customcombobox',
				name: 'visitorCardNo',
				itemId: 'visitorCardNo',
				fieldLabel: getServiceRequestTranslation('CARD_NO'),
				store: 'sgvisitor.SgAllVisitorCardStore',
				valueField: 'value',
				displayField: 'value',
				allowBlank: false,
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				triggerAction: 'all',
				hideTrigger:false,
				editable: false,
				style: {
					marginLeft: '-10px'
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					//emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'  +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',
				name: 'manualCardNo',
				itemId:'manualCardNo',
				hidden:true,
				allowBlank: false,
				queryParam:'visitorCard',
				fieldLabel: getServiceRequestTranslation('CARD_NO'),
				style: {
					marginLeft: '-10px'
				},
				maxLength:15,
			}]
		},{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textarea',
				name: 'visitorAddress',
				itemId: 'visitorAddress',
				fieldLabel: getServiceRequestTranslation('PARENT_ADDRESS'),
				width: 460,
				enforceMaxLength : true,
				maxLength:250,
				listener:{
					blur:function(){}
				}
			}]
		},{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype : 'timefield',
				name : 'inTime',		
				itemId : 'inTime',			
				fieldLabel:getServiceRequestTranslation('IN_TIME'),
				vtype: 'timerange',
				endTimeField : 'outTime',
				//value: new Date(),
				//submitFormat:'H:i:s',
				// fieldLabel: Ext.Date.format(new Date(), 'Y-m-d'),
				width:100,
				//submitFormat : 'g:i A',
				format:'g:i A',
				submitFormat : CONSTANTS.DISPLAY_TIME_FORMAT,
				allowBlank:false,
				editable: false,
				listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				},

			},{
				xtype : 'timefield',
				name : 'outTime',		
				itemId : 'outTime',			
				fieldLabel:getServiceRequestTranslation('OUT_TIME'),
				vtype: 'timerange',
				startTimeField :'inTime',
				//value: new Date(),
				width:100,
				//submitFormat : 'g:i A',
				format:'g:i A',
				submitFormat : CONSTANTS.DISPLAY_TIME_FORMAT,
				editable: false,
				disabled:true,
				listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				},
			}]
		},{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textarea',
				name: 'reasonToVisit',
				itemId: 'reasonToVisit',
				fieldLabel: getServiceRequestTranslation('REASON_FOR_VISIT'),
				width: 460,
				enforceMaxLength : true,
				maxLength:250,
				listener:{
					blur:function(){}
				}
			}]
		},{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'personToMeet',
				itemId : 'personToMeet',
				fieldLabel: getServiceRequestTranslation('PERSON_TO_MEET'),
				store:'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
				valueField: 'valueCode',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				forceSelection:true,
				allowBlank: false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				maxLength:400,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value} / {code}' +
						'</div>';
					}
				}
			},{
				xtype: 'fieldcontainer',
				fieldLabel: getServiceRequestTranslation('PERSON_CONTACT_NO'),
				name:'personContactNoLabel',
				itemId:'personContactNoLabel',
				layout : {
					type : 'hbox'
				},
				items : [ {
					xtype: 'customcombobox',
					valueField: 'isdCode',
					displayField: 'isdCode',
					store:Ext.create('Academia.store.common.CountryStore'),
					itemId:'personPhoneCountryCode',
					name:'personPhoneCountryCode',
					triggerAction: 'all',
					width: 80, 
					editable: false,

				}, {
					xtype: 'numberfield',
					name: 'personContactNo', 
					itemId:'personContactNo',
					minLength: 0,
					maxLength: 11,
					allowNegative: false,
					minValue: 1,
					mouseWheelEnabled:false,
					width: 135,
					emptyText: 'Mobile Number',
					hideTrigger:true,
					enforceMaxLength : true,			
				}]
			}]
		},{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype:'datefield',
				name: 'meetingDate',
				fieldLabel: getServiceRequestTranslation('MEETING_DATE'),
				itemId:'meetingDate',
				allowBlank: false,
				endDateField: 'tillDate',
				vtype: 'daterange',
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}

			},{
				xtype: 'customcombobox',
				name: 'entryBy',
				itemId: 'entryBy',
				fieldLabel: getServiceRequestTranslation('ENTRY_BY'),
				store:'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				allowBlank:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				maxLength: 360,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'checkboxfield',
				width: 'auto',
				labelAlign: 'right',
				style: {
					marginTop: '25px',
					marginLeft: '10px'
				},
				boxLabel: getServiceRequestTranslation('GOING_OUT_WITH_STUDENT'),
				name: 'isGoingOutWithStudent',
				itemId:'isGoingOutWithStudent',
				inputValue : true,
				hidden:true,
				uncheckedValue: false 
			},{
				xtype: 'checkboxfield',
				width: 'auto',
				labelAlign: 'right',
				itemId:'whether_deleted',
				style: {
					marginTop: '25px',
					marginLeft: '10px'
				},
				boxLabel: getServiceRequestTranslation('PARENT'),
				name: 'isParentOrGardian',
				itemId:'isParentOrGardian',
				inputValue : true,
				hidden:true,
				uncheckedValue: false 
			}]
		},{ 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'checkboxfield',
				width: 'auto',
				itemId:'isMultiDayPass',

				boxLabel: getServiceRequestTranslation('MULTI_DAY_PASS'),
				name: 'isMultiDayPass',
				inputValue : true,
				uncheckedValue: false 
			},{
				xtype: 'datefield',
				name: 'tillDate',
				itemId: 'tillDate',
				hidden:true,
				allowBlank:true,
				startDateField: 'meetingDate',
				vtype: 'daterange',
				fieldLabel: getServiceRequestTranslation('TILL_DATE'), //TILL Date
				editable: true,
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
				style: {
					//marginTop: '25px',
					marginLeft: '112px'
				},

			}]
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		style:{
			marginTop:'20px',
		    marginLeft:'5px'	
		},
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'saveVisitor',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			name:'resetVisitor',
			itemId : 'resetVisitor',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}],
           }]
      
   },{
	   xtype: 'panel',
       frame: false,
       width: '400px',
       style:{
    	   marginTop:'25px',
    	 //  marginLeft:'140px'
        },
       items: [{
           xtype: 'fieldcontainer',
           border: false,
           width: '400px',
           layout: {
               type: 'hbox',
               width: '400px',
           },
            items : [{
	        	xtype:'image',
	            itemId: 'visitorBgImage',
	            border: 1,
	            style: {
	                borderColor: 'black',
	                borderStyle: 'solid',
	                //marginLeft: '30px'
	            },
	            width: 130,
	            height: 150,
	        }]
       },{
           xtype: 'fieldcontainer',
           border: false,
           width: '400px',
           layout: {
               type: 'hbox',
               width: '400px',
           },
            items : [{
				xtype: 'photouploadform',
	        	itemId: 'logoUploadField',
	        	hidden:true,
	        },{
				xtype:'button',
				text:'Snapshot',
				itemId: 'personImagePathSnap',
				ui: 'CustomBtnSubmit',
				style: {
					marginTop: '20px',
					//marginLeft: '10px'
				},
				listeners:{
					click : function(){
						var window = Ext.widget('imagecapturewindow',{
							itemId:'sgvisitor'
						});
						window.show();
					}
				}
			}]
       }]
	}]
   }]
});
